<?php
/**
 * 易宝支付响应对象
 * User: yzxh24
 * Date: 11-9-27
 * Time: 下午5:50
 * To change this template use File | Settings | File Templates.
 */
class Yeepay_Response_ChargeCardDirect extends Yeepay_Response
{
    /**
     * 签名字段和顺序
     * 非专业版提交后服务器会返回一组参数，用来标明提交是否成功
     * 注意：提交成功并不代表支付成功
     * @var array
     */
    protected static $hashMap = array(
        'r0_Cmd' => 'command', // 业务类型，固定值 ”ChargeCardDirect”
        'r1_Code' => 'code', // 提交状态，“1”代表提交成功，非“1”代表提交失败
        'r6_Order' => 'order', // 商户订单号
        'rq_ReturnMsg' => 'returnMsg', // 错误代码
        'hmac' => 'hmac', // 服务器返回的签名数据
    );

    /**
     * 支付结果,值为“1”, 代表支付成功.非“1”失败。
     * @var string(20)
     */
    public $code;

    /**
     * 易宝支付返回商户订单号
     * @var string(20)
     */
    public $order;

    /**
     * 错误代码
     * @var string(100)
     */
    public $returnMsg;

    /**
     * 签名
     * @var string(100)
     */
    public $hmac;
}