<?php

/**
 * @author Jeffrey
 * @version $Id: Refund.php 32 2010-01-17 11:34:32Z jeffrey $
 */
class Yeepay_Response_Refund extends Yeepay_Response
{
    /**
     * 签名字段和顺序
     *
     * @var Array
     */
    protected static $hashMap = array(
        'r0_Cmd' => 'command',
        'r1_Code' => 'code',
        'r2_TrxId' => 'tradeId',
        'r3_Amt' => 'amount',
        'r4_Cur' => 'currency',
    );

    /**
     * 业务类型
     *
     * @var string(20)
     */
    protected $command = 'RefundOrd';

    /**
     * 查询结果
     *
     * @var string(50)
     */
    public $code;

    /**
     * 易宝支付交易流水号
     *
     * @var string(50)
     */
    public $tradeId;

    /**
     * 支付金额
     *
     * @var string(20)
     */
    public $amount;

    /**
     * 交易币种
     *
     * @var string(20)
     */
    public $currency = 'CNY';
}