<?php
/**
 * 充值卡验证
 * User: yzxh24
 * Date: 11-9-28
 * Time: 下午12:05
 * To change this template use File | Settings | File Templates.
 */
abstract class Yeepay_Validate
{
    /**
     * 充值卡的名称
     * @var string(20)
     */
    protected $name;
    
    /**
     * 充值卡相应的提示信息
     * 内容太长的话可切分成多条
     * @var array
     */
    protected $tips = array();

    /**
     * 卡支持的面额
     * @var array
     */
    protected $allowMoneyList = array();

    /**
     * 充值卡卡号
     * @var string(30)
     */
    protected $cardNum;

    /**
     * 充值卡密码
     * @var string(30)
     */
    protected $cardPass;

    /**
     * 卡号长度
     * @var string(20)
     */
    protected $cardNumLen;

    /**
     * 卡号是否为纯数字
     * @var bool
     */
    protected $cardNumIsNumber = true;

    /**
     * 充值卡密码长度
     * @var string(20)
     */
    protected $cardPassLen;

    /**
     * 充值卡密码是否为纯数字
     * @var bool
     */
    protected $cardPassIsNumber = true;

    /**
     * 验证充值卡
     * @params int $money
     * @return void
     */
    public function validate($money)
    {
        if ($this->cardNumLen != strlen($this->cardNum) || ($this->cardNumIsNumber && !is_numeric($this->cardNum)))
        {
            throw new Yeepay_Validate_Exception('充值卡卡号不正确');
        }

        if ($this->cardPassLen != strlen($this->cardPass) || ($this->cardPassIsNumber && !is_numeric($this->cardPass)))
        {
            throw new Yeepay_Validate_Exception('充值卡密码不正确');
        }

        if (!in_array($money, $this->getAllowMoneyList()))
        {
            throw new Yeepay_Validate_Exception('不支持的充值额度，当前只支持'.implode('、', $this->getAllowMoneyList()).'元的充值');
        }

        return true;
    }

    /**
     * 显示相应充值卡的提示信息
     * @return string(200)
     */
    public function getTips()
    {
        return $this->tips;
    }

    /**
     * 获得卡名
     * @return string(20)
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * 获得支持的面额，用来生成下拉列表
     * @return array
     */
    public function getAllowMoneyList()
    {
        return $this->allowMoneyList;
    }

    /**
     * 设置卡号
     * @param  $cardNum
     * @return void
     */
    public function setCardNum($cardNum)
    {
        $this->cardNum = $cardNum;
    }

    /**
     * 设置卡密
     * @param  $cardPass
     * @return void
     */
    public function setCardPass($cardPass)
    {
        $this->cardPass = $cardPass;
    }
}