<?php
/**
 * 盛大卡验证器
 * User: yzxh24
 * Date: 11-9-28
 * Time: 下午1:41
 * To change this template use File | Settings | File Templates.
 */
class Yeepay_Validate_SNDACARD extends Yeepay_Validate
{
    protected $name = '盛大卡';

    protected $tips = array('※请使用卡号以CSC5、CS、S、CA、CSB、YC、YD开头的“盛大互动娱乐卡”进行支付。');

    protected $allowMoneyList = array(5, 10, 30, 35, 45, 100, 350, 1000);

    public function validate($money)
    {
        if (15 != strlen($this->cardNum))
        {
            throw new Yeepay_Validate_Exception('不正确的充值卡号');
        }
        if (8 != strlen($this->cardPass) && 9 != strlen($this->cardPass))
        {
            throw new Yeepay_Validate_Exception('不正确的充值卡密码');
        }
        if (!in_array($money, $this->getAllowMoneyList()))
        {
            throw new Yeepay_Validate_Exception('不支持的充值额度，当前只支持'.implode('、', $this->getAllowMoneyList()).'元的充值');
        }

        return true;
    }
}