<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
class Attachment extends Model
{
	public static function single($className = __CLASS__)
	{
		if (is_null(self::$_self[$className]))
		{
			self::$_self[$className] = new $className;
		}
		
		return self::$_self[$className];
	}

    public static function table()
    {
        return 'ig_attachment';
    }
    
    public static function baseSavePath()
    {
        return ROOT_PATH . rtrim(setting('attachpath'),'\\/') . '/';
    }
    
    public static function baseThumbSavePath()
    {
        return self::baseSavePath() . 'thumb' . '/';
    }
    
    public static function baseThumbSaveUrl()
    {
        return self::baseSaveUrl() . 'thumb' . '/';
    }
    
    public static function baseSaveUrl()
    {
        global $path;
        return $path . rtrim(setting('attachpath'),'\\/') . '/';
    }
    
    public function getFile($attachment)
    {
        return self::baseSavePath() . $attachment;
    }
    
    public function getThumbFile($attachment)
    {
        return self::baseThumbSavePath() . $attachment;
    }
    
    public static function getImageSize($src, $ext)
    {
        empty($ext) && $srcExt = strtolower(substr(strrchr($src, '.'), 1));
    	$srcdata = array();
    	if (function_exists('read_exif_data') && in_array($srcExt, array('jpg','jpeg','jpe','jfif')))
    	{
    		$datatemp = @read_exif_data($src);
    		$srcdata['width'] = $datatemp['COMPUTED']['Width'];
    		$srcdata['height'] = $datatemp['COMPUTED']['Height'];
    		$srcdata['type'] = 2;
    		unset($datatemp);
    	}
    	!$srcdata['width'] && list($srcdata['width'], $srcdata['height'], $srcdata['type']) = @getimagesize($src);
    	if (!$srcdata['type'] || ($srcdata['type'] == 1 && in_array($srcExt, array('jpg','jpeg','jpe','jfif'))))
    	{
    		return false;
    	}
    	
    	return $srcdata;
    }
    
    public static function getUploadNum()
    {
		foreach ($_FILES as $key => $val)
		{
			if (!$val['tmp_name'] || $val['tmp_name'] == 'none')
			{
				unset($_FILES[$key]);
			}
		}
		return count($_FILES);
	}
	
	public function getOne($aid)
	{
	    $attachment = $this->Db()->select()->from(self::table())->where('id='.$aid.' AND isdelete=0')->find(true);
	    if (empty($attachment))
	    {
	        throw new AttachmentNotExistsException('不存在的附件');
	    }
	    
	    return $attachment;
	}
	
	public function deleteOne($aid, $tid)
	{
	    $this->Db()->update(self::table())->value(array('isdelete'=>1))->where('id='.$aid)->q();
	    	    $count = $this->Db()->getValue('SELECT COUNT(*) FROM '.self::table().' WHERE isdelete = 0 AND tid='.$tid);
	    if (!$count)
	    {
	        $this->Db()->update(Threads::table())->value(array('isupload'=>0))->where('id='.$tid)->q();
	    }
	}

    public function listView($strings, $tid, $offset = 0, $pageSize = 5)
    {
        if (empty($strings))
        {
            return '';
        }

        $pageObj = new iPage();
        $pageObj->setTotalRecord(count($strings));
        $pageObj->setPageSize($pageSize);
        $pageObj->setBaseUrl(url('system', array('s'=>'bbs','c'=>'attachment','a'=>'list','tid'=>$tid)));

        if (is_array($strings))
        {
            $sArray = array_splice($strings, $offset, $pageSize);
            $sCount = count($sArray);
            $sArray[$sCount - 1] = $sArray[$sCount - 1] . '<br/>' . $pageObj->show();
            $strings = array();
            $strings = $sArray;
        }

        return $strings;
    }
}

class AttachmentNotExistsException extends Exception {}
class AttachmentIsEmpty extends Exception {}
class AttachmentIsNotValid extends Exception {}
class AttachmentIsToLarge extends Exception {}
class AttachmentSizeCanNotZero extends Exception {}
class AttachmentPriceNotValid extends Exception {}