<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
class Authors extends Model
{
	public static function single($className = __CLASS__)
	{
		if (is_null(self::$_self[$className]))
		{
			self::$_self[$className] = new $className;
		}
		
		return self::$_self[$className];
	}
	
    public static function table()
    {
        return 'ig_author';
    }

    public function isOwner($bookId, $uid)
    {
        $book = $this->Db()->select()->from(Book::table())->where('bookid='.S::sqlEscape($bookId).' AND authorid='.S::sqlEscape($uid))->find(true);
        if (empty($book))
        {
            throw new UserIsNotOwnerException('你不是此书的作者');
        }
        
        return $book;
    }

    public function isAuthor($uid)
    {
        $check = $this->Db()->getValue('SELECT id FROM '.self::table().' WHERE uid = '.$uid);
        
        return $check ? $check : false;
    }

    public function getAuthorId($authorName)
    {
        return $this->Db()->getValue('SELECT id FROM '.self::table().' WHERE name='.S::sqlEscape($authorName));
    }

    public function getUid($authorId)
    {
        return $this->Db()->getValue('SELECT uid FROM '.self::table().' WHERE id='.S::sqlEscape($authorId));
    }
}

class UserIsNotOwnerException extends Exception {}