<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
class BcartSubject extends Model
{
    public static $scoreMapArray = array(
        5 => '仙草',
        4 => '粮草',
        3 => '干粮',
        2 => '毒草',
        1 => '剧毒',
    );
    
    public static function table()
    {
        return 'ig_bcartsubject';
    }

	public static function single($className = __CLASS__)
	{
		if (!isset(self::$_self[$className]))
		{
			self::$_self[$className] = new $className;
		}

		return self::$_self[$className];
	}

    public static function getScoreLink($subject)
    {
        $count = $subject['s1'] + $subject['s2'] + $subject['s3'] + $subject['s4'] + $subject['s5'];
        $mapArray = self::$scoreMapArray;
        $linkArray = array();
        foreach ($mapArray as $key => $value)
        {
            $linkArray[] = ilink($value, url('system', array('s'=>'bcart','a'=>'bscore','id'=>$subject['id'],'t'=>$key)));
        }

        return implode('.', $linkArray);
    }

    public static function getScore($subject)
    {
        $count = $subject['s1'] + $subject['s2'] + $subject['s3'] + $subject['s4'] + $subject['s5'];
        if ($count <= 0)
        {
            return false;
        }

        $max = max(array($subject['s1'], $subject['s2'], $subject['s3'], $subject['s4'], $subject['s5']));
        $point = round($max / $count, 2) * 100 . '%';

        $x1 = 0.8; // 评分所占的权重
        $x2 = 0.2; // 评分次数所占的权重

        return array('tag' => self::$scoreMapArray[$round], 'point' => $point);
    }
}
