<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
class BookPostReply extends Model
{
	public static function single($className = __CLASS__)
	{
		return parent::single($className);
	}
    
    public static function table()
    {
        return 'ig_bookpostreply';
    }

    public function create($bookId, $data = array())
    {
        $table = $this->escape(self::table());
        $sql = "INSERT INTO $table SET ";
        $data['createdate'] = time();
        $data['loginip'] = $_SERVER['REMOTE_ADDR'];
        if (mb_strlen(trim($data['content']), 'utf-8') < '2')
        {
            iexit('内容长度必须大于2个字');
        }

        $insert[] = self::getEscapeString('bookid', $bookId);

        foreach ($data as $key => $value)
		{
			$insert[] = self::getEscapeString($key, $value);
		}
		$sql .= implode(',', $insert);
		$this->_db->query($sql);

		return $this->_db->getInsertId();
    }

    public function getThread($postId)
    {
        return $this->_db->select()->from(self::table())->where(array('postid'=>$postId,'isfirst'=>1))->find(true);
    }

    public function mustBuy($thread)
    {
        global $iorange_id;

        return $thread['price'] && !in_array($iorange_id, (!empty($thread['buyer']) ? explode(',', $thread['buyer']) : array()));
    }

    public function halt($thread)
    {
        $message[] = '此贴售价'.$thread['price'].'，必须先购买才能观看,为避免上当受骗,下面列举此贴当前相关信息!';
        $message[] = '购买:'.(!empty($thread['buyer']) ? count(array_diff(explode(',',$thread['buyer']), array(''))) : 0);
        $message[] = '好评:'.(!empty($thread['good']) ? count(array_diff(explode(',', $thread['good']),array(''))) : 0);
        $message[] = '差评:'.(!empty($thread['bad']) ? count(array_diff(explode(',', $thread['bad']),array(''))) : 0);
        $message[] = '投诉:'.(!empty($thread['complaints']) ? count(array_diff(explode(',', $thread['complaints']),array(''))) : 0);
        $message[] = '请根据这些信息判断是否'.ilink('购买',url('system',array('s'=>'forum','c'=>'advance','a'=>'buy','id'=>$thread['bookid'],'cid'=>$thread['postid'])));
        iexit($message);
    }
}