<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
class Forums extends Model
{
	public static function single($className = __CLASS__)
	{
		return parent::single($className);
	}
	
    public static function table()
    {
        return 'ig_forums';
    }
    
    public function getOne($fid, $fields = '*')
    {
        return $this->Db()->select($fields)->from(self::table())->where('fid='.$fid)->find(true);
    }
    
    public function getAll($fields = '*')
    {
        $this->Db()->select($fields)->from(self::table())->find();
    }
    
    public function getCache($fid)
    {
        static $_cache = array();
        if (!isset($_cache[$fid]))
        {
            $_cache[$fid] = require_once ROOT_PATH . 'cache/bbs/forums/forum_'.$fid.'.php';
        }
        
        return $_cache[$fid]; 
    }
    
    public static function getTypeList($fid)
    {
        return TopicType::getList($fid);
    }

    public function getForumsCache()
    {
        static $_forums = null;
        if (is_null($_forums))
        {
            $_forums = require ROOT_PATH . 'cache/bbs/forums/forums.php';
        }
        return $_forums;
    }

    public function getChilds($fid)
    {
        $cache = $this->getForumsCache();
        $childs = array();
        foreach ($cache as $key => $value)
        {
            if ($value['fup'] == $fid)
            {
                $childs[$key] = $value['name'];
            }
        }
        
        return $childs;
    }

    public function getBM($fid)
    {
        $forum = $this->getCache($fid);
        if (empty($forum['forumadmin']))
        {
            return '';
        }
        
        return $forum['forumadmin'];
    }

    public function isBM($fid, $uid)
    {
        $bm = $this->getBM($fid);
        if (empty($bm))
        {
            return false;
        }
        
        if (false !== strpos($bm, ','.$uid.','))
        {
            return true;
        }
        
        return false;
    }
}