<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
class MessageData extends Model
{
    private $_did = null;
    private $_subject = '';
    private $_content = '';

    public static function table()
    {
        return 'ig_messagedata';
    }

	public static function single($className = __CLASS__)
	{
		return parent::single($className);
	}
	
	public function create($subject, $content)
	{
	    $subject = S::escapeChar(trim($subject));
	    $content = S::escapeChar(trim($content));

	    if (empty($subject))
	    {
	        throw new Exception('标题不能为空');
	    }
	    if (empty($content))
	    {
	        throw new Exception('内容不能为空');
	    }
	    
	    $this->Db()->insert(self::table())->value(array('subject'=>$subject,'message'=>$content,'createdate'=>CTIME))->q();
	    $this->_did = $this->Db()->getInsertId();
	    $this->_subject = $subject;
	    $this->_content = $content;
	    
	    return $this->getDid();
	}
	
	public function getDid()
	{
	    return $this->_did;
	}
	
	public function getSubject()
	{
	    return $this->_subject;
	}
	
	public function getContent()
	{
	    return $this->_content;
	}
}