<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
class Posts extends Model
{
    public static $pageSize = 10;
    
    public static function table()
    {
        return 'ig_posts';
    }

	public static function single($className = __CLASS__)
	{
		if (!isset(self::$_self[$className]))
		{
			self::$_self[$className] = new $className;
		}

		return self::$_self[$className];
	}

    public function getOne($postId)
    {
        if (empty($postId))
        {
            throw new PostParamErrorException('非法操作，请返回');
        }

        $post = $this->db()->select(array('id','tid','uid','content','floor','createdate','toped'))->from(Posts::table())->where('id='.$postId)->find(true);
        if (empty($post))
        {
            throw new PostNotExistsException('不存在的回复');
        }

        return $post;
    }

    public static function ubb($matches)
    {
        $floor = $matches[1];
        $pid = $matches[2];
        if (!is_numeric($floor) || !is_numeric($pid))
        {
            return $matches[0];
        }

        return str_replace($matches[1], ilink('['.$floor.'楼]', url('system', array('s'=>'bbs','c'=>'post','a'=>'to','pid'=>$pid))), $matches[1]);
    }

    public static function cut($matches)
    {
        $content = $matches[1];
        if (mb_strlen($content, 'utf-8') < 200)
        {
            return $content;
        }

        $content = mb_substr($content, 0, 200, 'utf-8') . ilink('...更多&gt;&gt;', url('system', array('s'=>'bbs','c'=>'post')));
        return str_replace($matches[1], $content, $matches[1]);
    }
}

class PostsException extends Exception {}
class PostParamErrorException extends PostsException {}
class PostNotExistsException extends PostsException {}