<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
define('IN_IORANGE', true);
require_once 'include/init.php';

isLogin();

$bookid = S::gp('bid','G', 2);
$chapterid = S::gp('cid','G', 2);
$book = fetchBookInfo($bookid);
if (empty($book))
{
    _errorMessage('不存在的小说');
}

$typeList = array(1=>'章节重复',2=>'书城更新慢了',3=>'章节内容不对',4=>'无法阅读');

if (isset($_POST['type']))
{
    $type = S::gp('type', 'P', 2);
    $remark = S::gp('remark', 'P');
    if (!key_exists($type, $typeList))
    {
        _errorMessage('非法请求');
    }

    $check = $db->getValue('SELECT COUNT(*) FROM '.Report::table().' WHERE cid='.$chapterid.' AND uid='.$iorange_id);
    if ($check)
    {
        _errorMessage('您已经提交过该章节的错误，请不要重复提交');
    }

    $chapter = Chapter::single()->getOne($chapterid);
    $url = staticUrl('read',array('bid'=>$bookid,'cid'=>$chapterid));
    $insert = array('uid'=>$iorange_id,'username'=>$username,'bid'=>$bookid,'bookname'=>$book['bookname'],'chaptername'=>$chapter['chaptername'],'cid'=>$chapterid,'createdate'=>CTIME,'date'=>date('Y-m-d'),'remark'=>$remark,'url'=>$url,'type'=>$typeList[$type]);
    $check = $check = $db->getValue('SELECT COUNT(*) FROM '.Report::table().' WHERE cid='.$chapterid.' AND date = '.S::sqlEscape(CDATE));
    if (!$check)
    {
        $insert['isfirst'] = 1;
    }

    $db->insert(Report::table())->value($insert)->q();

    $message = '感谢您的报错,我们将尽快修复';
    if (setting('reportaward'))
    {
        $message = '感谢您的报错,我们将尽快修复,如果您是第一位正确汇报错误的书友,系统将给与'.setting('reportaward').setting('creditname').'的奖励,请注意查收站内短信,感谢您的支持与谅解.';
    }
    if (isWebRequest())
    {
        _errorMessage($message, 1);
    }
    else
    {
        $e = $message;
        $message = array();
        $message[] = $e;
        $message[] = '返回'.ilink('继续阅读', url('read',array('bid'=>$bookid,'cid'=>$chapterid,'sp'=>S::gp('sp')))).'.'.memberLink();
        iexit($message);
    }
}

include_once tpl('report');

function _errorMessage($message, $status = 0)
{
    if (isWebRequest())
    {
        die(json_encode(array('status' => $status, 'msg' => $message)));
    }
    iexit($message);
}