<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
define('IN_IORANGE', true);
require_once "include/init.php";

$class = S::gp('class','G',2);
$size = S::gp('size', 'G', 2);
$tid = S::gp('tid', 'G', 2);
$status= S::gp('status', 'G', 2);
$info = urldecode(S::gp('info', 'G'));
$key = urldecode(S::gp('key','G'));
$author = urldecode(S::gp('author', 'G'));
$keyWords = urldecode(S::gp('keywords', 'G'));

if (empty($class))
{
    iexit('非法访问');
}
$key = preg_replace('/(select|union|%|\*)/i', '', $key);
$author = preg_replace('/(select|union|%|\*)/i', '', $author);
$keyWords = preg_replace('/(select|union|%|\*)/i', '', $keyWords);

if (empty($key) && empty($author) && empty($info) && empty($keyWords))
{
    iexit('请输入搜索关键字');
}

$condition = array('view = 1');
if ($class == 1)
{
    $key && $condition[] = "bookname LIKE '%{$key}%'";
    if (isset($_GET['status']) && 3 != $status)
    {
        $condition[] = '`status` = ' . ($status ? 1 : 0);
    }
    $tid && $condition[] = 'b.typeid = '.$tid;
    $info && $condition[] = "b.bookinfo LIKE '%$info%'";
    $author && $condition[] = "b.author LIKE '%$author%'";
    $size && $condition[] = getSize($size);
    if (!empty($keyWords))
    {
        $keyArray = explode(' ', $keyWords);
        foreach ($keyArray as $k)
        {
            $condition[] = "keywords LIKE '%$k%'";
        }
    }
}
else
{
    $key = !empty($key) ? $key : $author;
    $condition[] = "author LIKE '%$key%'";
}

$sortKey = array(
    'click' => '点击',
    'favorites' => '收藏',
    'size' => '字数',
    'updatedate' => '更新',
    'flower' => '鲜花',
    'egg' => '板砖',
);
$sort = empty($_GET['sort']) || !key_exists($_GET['sort'], $sortKey) ? 'click' : trim(S::gp('sort','G'));
foreach ($sortKey as $k => $v)
{
    if ($k == $sort)
    {
        $nav[] = $v;
    }
    else
    {
        $param = $_GET;
        unset($param['st'], $param['sort'], $param['sid']);
        $url = url('search', array_merge($param, array('sort'=>$k)));
        $nav[] = ilink($v, $url);
    }
}
$navString = implode('.', $nav);

$sqlAdd = implode(' AND ', $condition);
$pageSize = isWebRequest() ? 20 : 10;
$count = $db->getValue('SELECT COUNT(*) FROM '.Book::table().' AS b WHERE '.$sqlAdd);
$pageObj = new iPage();
$pageObj->setPageSize($pageSize);
$pageObj->setTotalRecord($count);

$sql = "SELECT bookid,size,typeid,bookname,cmbid,bookinfo,lastchaptername,lastchapterid,wlastchaptername,wlastchapterid,updatedate,author,status
        FROM `".Book::table()."` AS b
        WHERE {$sqlAdd}
        ORDER BY `{$sort}` DESC LIMIT ".$pageObj->getOffset().','.$pageObj->getPageSize();
$search = $db->setQueryString($sql)->find();

if (!empty($search))
{
    foreach ($search as &$s)
    {
        $s['bookinfo'] = iSubstr(preg_replace("/\s/i", '', preg_replace("/\n/i", '', preg_replace("/　/i", '', $s['bookinfo']))), 0, 40, '...');
    }
}

if ($pageObj->getCurrentPage() == 1 && !isWebRequest())
{
    $valid = CMOBILE ? 1 : (CUNICOM ? 2 : 0);
    $resultCount = $pageObj->getTotalRecord();
    $ruid = $ruid ? $ruid : 0;
    $key = empty($key) ? $author : $key;
    $type = 1 == $class ? 1 : 2;
    $db->insert(BookSearch::table())->value(array('keyword' => $key, 'type' => $type, 'uid' => $iorange_id, 'ruid' => $ruid, 'createdate' => CDATETIME, 'date' => CDATE,'ip' => ONLINE_IP,'valid' => $valid, 'count' => $resultCount))->q();
}
$floor = $pageObj->getFloor();

include_once tpl('search');

function getSize($id)
{
    switch ($id)
    {
        case 1:
            return ' (b.`size` < 300000)';
        case 2:
            return ' (b.`size` > 300000 AND b.`size` < 500000)';
        case 3:
            return ' (b.`size` > 500000 AND b.`size` < 1000000)';
        case 4:
            return ' (b.`size` > 1000000 AND b.`size` < 2000000)';
        case 5:
            return ' (b.`size` > 2000000)';
        default:
            return ' (b.`size` > 1000)';
    }
}