<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
class AuthorAction extends BaseAction
{
    public $ubbMap = array(
        'find' => array('[h]', '[kk]', '[k]', '[kk]', '[k]'),
        'replace' => array("\n" ,'&nbsp;&nbsp;', '&nbsp;', '  ', ' '),
    );
    private $_authorId;
    private $_authorName;
    private $_authorStatus;
    
    public function run()
    {
        isAuthorization();
        throw new iSystemException('子类必须覆盖此方法');
    }
    
    public function init()
    {
        $author = $this->db()->select()->from(Authors::table())->where(array('uid'=>$this->uid()))->find(true);
        if (empty($author))
        {
            $apply = $this->db()->select()->from(AppWriter::table())->where(array('uid'=>$this->uid()))->find(true);
            if (!empty($apply))
            {
                $this->db()->insert(Authors::table())->value(array('uid'=>$this->uid(),'name'=>$apply['name'],'status'=>1,'createdate'=>date('Y-m-d H:i:s')))->q();
                $author['id'] = $this->db()->getInsertId();
                $author['name'] = $apply['name'];
                $author['status'] = 1;
            }
            else if (empty($apply) && !in_array($this->getName(), array('register','append')))
            {
                throw new iSystemException('您还不是本站的原创作者，不能进入<br/>点击'.$this->getController()->link('申请',$this->getController()->url('system',array('s'=>'author','a'=>'register'))));
            }
        }
        else
        {
            if (!empty($author) && 1 != $author['status'])
            {
                throw new iSystemException('您当前的状态为"封锁"，如有疑问请联系网站管理人员');
            }
        }
        $this->_authorId = $author['id'];
        $this->_authorName = $author['name'];
        $this->_authorStatus = $author['status'];
    }
    
    public function isBookOwner($bookId)
    {
        try
        {
        	$book = Authors::single()->isOwner($bookId, $this->getAuthorId());
        }
        catch (UserIsNotOwnerException $exce)
        {
            throw new iSystemException($exce->getMessage());
        }
        return $book;
    }

    public function editAnalyze($content)
    {
        return iTool::editAnalyze($content);
    }

    public function saveAnalyze($content)
    {
        return iTool::saveAnalyze($content);
    }
    
    public function getAuthorId()
    {
        return $this->_authorId;
    }
    
    public function getAuthorName()
    {
        return $this->_authorName;
    }
    
    public function getAuthorStatus()
    {
        return $this->_authorStatus;
    }
}