<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
class EditAction extends AuthorAction
{
    public function run()
    {
        $bookId = S::gp('bid','G',2);
        $book = $this->isBookOwner($bookId);
        
        if (isset($_POST['bookinfo']))
        {
    		$bookinfo = filter_content(trim(S::gp('bookinfo','P')));
    		if (empty($bookinfo) || mb_strlen($bookinfo, 'utf8') > 200)
    		{
    			throw new iSystemException('小说简介长度不符号要求(不能大于200或小于0个字)');
    		}
    		
    		$this->db()->update(Book::table())->value(array('bookinfo'=>$bookinfo))->where('bookid='.S::sqlEscape($bookId))->q();
    		updateBookInfo($bookId);
    		
    		$message[] = '修改成功';
    		$message[] = '返回'.ilink('作者中心',$this->getController()->url('system',array('s'=>'author'))).'.'.ilink('章节管理',$this->getController()->url('system',array('s'=>'author','c'=>'chapter','bid'=>$bookId)));
    		$this->showMessage($message);
        }
        $this->getController()->render('edit', array('book'=>$book));
    }
}