<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
class RecommendAction extends AuthorAction
{
    public function run()
    {
        $bookid = S::gp('bid', 'G');
        $book = fetchBookInfo($bookid);
        if (empty($book))
        {
            throw new iSystemException('不存在的小说');
        }
        $this->isBookOwner($bookid);

        if ($book['size'] < 10000)
        {
            throw new iSystemException('不足1W字的小说不能申请推荐');
        }

        if (isset($_POST['name']))
        {
            $name = S::gp('name');
            if (empty($name))
            {
                throw new iSystemException('请输入要推荐的名称，格式: 推荐描述+书名 =11字,例如:废物的成长修真《百炼成仙》,请严格按照格式.');
            }
            $strlen = mb_strlen($name, 'utf-8');
            if ($strlen > 14 || $strlen < 10)
            {
                throw new iSystemException('推荐的名称长度不能小于10或者大于14个字');
            }
            $name = sFilter($name);
            $check = $this->db()->getValue('SELECT COUNT(*) FROM '.Recommend::table().' WHERE id='.S::sqlEscape($book).' AND `type`="book"');
            if (!$check)
            {
                $this->db()->insert(Recommend::table())->value(array('id'=>$bookid,'type'=>'book','createdate'=>CDATE))->q();
            }
            $this->db()->update(Book::table())->value(array('aliasname'=>$name))->where(array('bookid'=>$bookid))->q();
            updateBookInfo($bookid);
            updateCommend();

            $message[] = '恭喜，自助推荐成功，赶紧去首页看看吧';
            $message[] = '返回'. indexLink().'.'.memberLink().'.'.ilink('作者中心', url('system', array('s'=>'author')));
            $this->showMessage($message);
        }

        $this->getController()->render('recommend', array('bookid'=>$bookid));
    }
}