<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
class CreateAction extends AuthorAction
{
    public function run()
    {
        $bookId = S::gp('bid','G',2);
        $book = $this->isBookOwner($bookId);
        
        if (isset($_POST['chaptername']))
        {
            $chaptername = filter_content(S::gp('chaptername','P'));
    		if (mb_strlen($chaptername,'utf-8') > 40 || mb_strlen($chaptername,'utf-8') < 3)
    		{
    			$this->_showMessage('章节名长度不符合要求(必须大于3个或小于40个字)');
    		}
    
            $data = array(
                'chaptername' => $chaptername,
                'content' => ' ',
                'display' => 0,
                'isvip' => $book['isvip'] ? 1 : 0,
            );

            Chapter::single()->create($bookId, $data);

            if ($this->getController()->isWebRequest())
            {
                $this->_showMessage('新章节添加成功', 1);
            }
    		$forward = $this->getController()->url('system',array('s'=>'author','c'=>'chapter','bid'=>$bookId));
    		iforward($forward);
        }
        
        $this->getController()->render('create', array(
                'book' => $book
            )
        );
    }
}