<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
class EditAction extends AuthorAction
{
    public function run()
    {
        $bookId = S::gp('bid','G',2);
        $chapterId = S::gp('cid','G',2);
        $book = $this->isBookOwner($bookId);
        $chapter = Chapter::single()->getOne($chapterId);
        if (empty($chapter))
        {
            $this->_showMessage('不存在的章节', 0, false);
        }
        if ($chapter['bookid'] != $book['bookid'])
        {
            $this->_showMessage('非法操作', 0, false);
        }
        
        if (isset($_POST['chaptername']))
        {
            $chaptername = filter_content(S::gp('chaptername','P'));
    		if (mb_strlen($chaptername,'utf-8') > 40 || mb_strlen($chaptername,'utf-8') < 3)
    		{
    			$this->_showMessage('章节名长度不符合要求(必须大于3个或小于40个字)');
    		}
    
            $data = array(
                'chaptername' => $chaptername,
            );
            Chapter::single()->update($chapterId, $bookId, $data);
            if ($this->getController()->isWebRequest())
            {
                $this->_showMessage('修改成功', 1);
            }
    
    		$forward = $this->getController()->url('system',array('s'=>'author','c'=>'chapter','bid'=>$bookId));
    		iforward($forward);
        }
        
        $chapterContent = Chapter::single()->getContent($bookId, $chapterId);
        $this->getController()->render('edit', array(
                'book' => $book,
                'chapter' => $chapter,
                'chapterContent' => $chapterContent,
            )
        );
    }
}