<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
class AppendAction extends AuthorAction
{
    public function run()
    {
        $id = S::gp('id','G',2);
        $apply = $this->db()->select()->from(AppWriter::table())->where(array('id'=>$id))->find(true);
        if (empty($apply) || $this->uid() != $apply['uid'])
        {
            throw new iSystemException('不存在的申请');
        }
        if ($apply['done'])
        {
        	throw new iSystemException('当前申请内容已经完成，不能再续贴');
        }
        
        $do = isset($_GET['do']) ? S::gp('do','G') : '';
        if (!in_array($do, array('add','complete')))
        {
            throw new iSystemException('无效请求');
        }
        
        if ('complete' == $do)
        {
            $this->db()->update(AppWriter::table())->value(array('done'=>1,'updatedate'=>CDATETIME))->where(array('id'=>$id))->q();
            $message[] = '设置成功';
            $message[] = '返回'.ilink('作者中心',$this->getController()->url('system',array('s'=>'author'))).'.'.memberLink().'.'.indexLink();
            $this->showMessage($message);
        }
        else if ('add' == $do)
        {
            if ($_POST['content'])
            {
        	    $content = filter_content(S::gp('content','P'));
        	    $size = mb_strlen($content, 'utf8');
        	    if (empty($content) || $size > 50)
        	    {
        	    	throw new iSystemException('每次续贴的内容长度不能为空或者超过50个字');
        	    }
        	    
        	    $content = "\n" . $content;
        		$done = S::gp('done','P',2);
        	    $this->db()->query("UPDATE `".AppWriter::table()."` SET `content` = CONCAT(`content`,'$content'), `size`=`size`+$size, `done` = $done WHERE `id` = '$id'");
        	    
        	    $message[] = '续贴成功';
        	    $message[] = '返回'.ilink('继续',$this->getController()->url('system',array('s'=>'author','a'=>'append','do'=>'add','id'=>$id))).'.'.ilink('作者中心',$this->getController()->url('system',array('s'=>'author'))).'.'.memberLink();
        	    $this->showMessage($message);
            }
            
            $this->getController()->render('append', array('apply'=>$apply));
        }
    }
}