<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
class RegisterAction extends AuthorAction
{
    public function run()
    {
        $isWebRequest = $this->getController()->isWebRequest();
        header('Cache-control: private, must-revalidate');
        session_cache_limiter("private");
        
        $check = $this->db()->select()->from(AppWriter::table())->where(array('uid'=>$this->uid()))->desc('id')->find(true);
        if (!empty($check))
        {
            throw new iSystemException('您已经是原创作家，请不要重复申请');
        }
        
        if (isset($_POST['content']))
        {
            $content = $this->getController()->filter(S::gp('content','P'));
        	$name = S::gp('name','P');
        	
        	$check = $this->db()->select()->from(Authors::table())->where(array('name'=>$name))->find(true);
        	if (!empty($check))
        	{
        		throw new iSystemException('你选择的笔名"'.$name.'"当前已经有人在使用，请换一个再提交');
        	}
        
            if (empty($content))
            {
                throw new iSystemException('请填写内容');
            }
            
            $size = mb_strlen($content, 'utf8');
            if ($size > 3000 || ($isWebRequest && $size < 100))
            {
                throw new iSystemException('提交的内容长度不能小于100或者大于3000个字');
            }
            
            $done = $isWebRequest ? 1 : S::gp('done','P',2);
            $created = date('Y-m-d H:i:s');
            $this->db()->insert(AppWriter::table())->value(array('uid'=>$this->uid(),'username'=>$name,'createdate'=>$created,'content'=>$content,'size'=>$size,'done'=>$done,'status'=>1))->q();
            
            $this->db()->insert(Authors::table())->value(array('uid'=>$this->uid(),'name'=>$name,'status'=>1,'createdate'=>$created))->q();
            $message[] = '恭喜您注册成为本站作家，现在您可以放回作者中心开始您的创作之旅了！';
            $message[] = '返回'.$this->getController()->link('作者中心',$this->getController()->url('system',array('s'=>'author'))) . '.' . indexLink().'.'.memberLink();
            $this->showMessage($message);
        }
        
        $this->getController()->render('register');
    }
}