<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
class CreateAction extends AuthorAction
{
    public function run()
    {
        $chapter = $this->getController()->getChapter();
        $book = $this->isBookOwner($chapter['bookid']);
        
        if (isset($_POST['content']))
    	{
            $content = $this->saveAnalyze(trim(S::gp('content','P')));
    		$subject = filter_content(trim(S::gp('subject','P')));
    
    		$subjectLen = mb_strlen($subject, 'utf-8');
    		if ($subjectLen > 40 || $subjectLen < 1)
    		{
    			$this->_showMessage('备注名长度不符合要求(必须大于0个或小于40个字)');
    		}
    
    		$size = mb_strlen($content,'utf8');
    		if ($size < 1)
    		{
    			$this->_showMessage('续传章节内容长度不符合要求(必须大于0个字)');
    		}

            $sort = $this->db()->getValue('SELECT sort FROM '.Draft::table().' WHERE chapterid='.$chapter['chapterid'].' AND deleted = 0 ORDER BY sort DESC LIMIT 1');
    		$sort += 1;
            $this->db()->insert(Draft::table())->value(array('authorid'=>$this->getAuthorId(),'author'=>$this->getAuthorName(),'uid'=>$this->uid(),'username'=>$this->userName(),'subject'=>$subject,'content'=>$content,'size'=>$size,'createdate'=>CDATETIME,'sort'=>$sort,'chapterid'=>$chapter['chapterid'],'bookid'=>$book['bookid']))->q();

            if ($this->getController()->isWebRequest())
            {
                $this->_showMessage('保存成功', 1);
            }
    		$message[] = '章节续传成功，'.ilink('继续添加',$this->getController()->url('system',array('s'=>'author','c'=>'draft','a'=>'create','cid'=>$chapter['chapterid']))).'？';
    		$message[] = '返回'.ilink('续传列表', $this->getController()->url('system',array('s'=>'author','c'=>'draft','cid'=>$chapter['chapterid']))).'.'.ilink('章节列表',$this->getController()->url('system',array('s'=>'author','c'=>'chapter','bid'=>$book['bookid']))).'.'.ilink('作者中心', $this->getController()->url('system',array('s'=>'author')));
    		$this->showMessage($message);
    	}
    	
    	$this->getController()->render('create', array(
    	        'chapter' => $chapter,
    	    )
    	);
    }
}