<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
class EditAction extends AuthorAction
{
    public function run()
    {
        $id = S::gp('id','G',2);
        $chapter = $this->getController()->getChapter();
    	$draft = $this->db()->select()->from(Draft::table())->where(array('id'=>$id))->find(true);
    	if (empty($draft))
    	{
    		$this->showMessage('不存在的续传信息', 0, false);
    	}
    	if ($draft['chapterid'] != $chapter['chapterid'])
    	{
    	    $this->showMessage('非法修改，已禁止', 0, false);
    	}
    	if ($draft['authorid'] != $this->getAuthorId())
    	{
    		$this->showMessage('此段章节不属于您，不能修改', 0, false);
    	}
    	
        if (isset($_POST['content']))
        {
            $content = $this->saveAnalyze(S::gp('content','P'));
    		$subject = filter_content(trim(S::gp('subject','P')));
    
            $subjectLen = mb_strlen($subject, 'utf-8');
    		if ($subjectLen > 40 || $subjectLen < 1)
    		{
    			$this->_showMessage('备注名长度不符合要求(必须大于0个或小于40个字)');
    		}
    
    		$size = mb_strlen($content,'utf8');
    		if ($size < 1)
    		{
    			$this->_showMessage('续传章节内容长度不符合要求(必须大于0个字)');
    		}

    		$this->db()->update(Draft::table())->value(array('subject'=>$subject,'content'=>$content,'size'=>$size,'updatedate'=>CDATETIME))->where(array('id'=>$id))->q();
            if ($this->getController()->isWebRequest())
            {
                $this->_showMessage('修改成功', 1);
            }
    		$message[] = '章节续传成功，'.ilink('继续添加',$this->getController()->url('system',array('s'=>'author','c'=>'draft','a'=>'create','cid'=>$chapter['chapterid']))).'？';
    		$message[] = '返回'.ilink('续传列表', $this->getController()->url('system',array('s'=>'author','c'=>'draft','cid'=>$chapter['chapterid']))).'.'.ilink('章节列表',$this->getController()->url('system',array('s'=>'author','c'=>'chapter','bid'=>$chapter['bookid']))).'.'.ilink('作者中心', $this->getController()->url('system',array('s'=>'author')));
    		$this->showMessage($message);        
        }

        $draft['content'] = $this->getController()->isWebRequest() ? $draft['content'] : $this->editAnalyze($draft['content']);
    	$this->getController()->render('edit', array(
    	        'chapter' => $chapter,
    	        'draft' => $draft,
    	    )
    	);
    }
}