<?php
/**
 * 社区控制器父类
 * @author yzxh24
 */
class BbsController extends BaseController
{
    public function getForumCache($fid)
    {
        return Forums::single()->getCache($fid);
    }
    
    public function getForumListCache()
    {
        return require ROOT_PATH . 'cache/bbs/forums/forums_list.php';
    }
    
    public function getForumsCache()
    {
        return Forums::single()->getForumsCache();
    }
    
    /**
     * 社区导航条(代码参考phpwind8)
     * @param int $fid
     * @param int $fup
     * @param int $type
     * @return array
     */
    public function nav($fid, $type = 1)
    {
        $page = S::gp('page', 'G', 2);
        $forums = $this->getForumsCache();
        $fup = $forums[$fid]['fup'];
        $secondurl = $this->url('system',array('s'=>'bbs','a'=>'forum','fid'=>$fid));
        $page > 1 && $secondurl . '&amp;page='.$page;
        
        $fup_array = $type ? array(strip_tags($forums[$fid]['name']),$secondurl) : array(strip_tags($forums[$fid]['name']));
        if ($forums[$fup]['type'] == 'category')
        {
    		$cateid = $forums[$fup]['fid'];
    		$guidename = array(
    			$cateid => $fup_array
    		);
    	}
    	elseif ($forums[$fup]['type'] == 'forum')
    	{
    		$cateid = $forums[$fup]['fup'];
    		$guidename = array(
    			$cateid => array(strip_tags($forums[$fup]['name']),$this->url('system',array('s'=>'bbs','a'=>'forum','fid'=>$forums[$fup]['fid']))),
    			$fup	=> $fup_array
    		);
    	}
    	elseif ($forums[$fup]['type'] == 'sub')
    	{
    		$fup1 = $forums[$fup]['fup'];
    		$cateid = $forums[$fup1]['fup'];
    		$guidename = array(
    			$cateid => array(strip_tags($forums[$fup1]['name']),$this->url('system',array('s'=>'bbs','a'=>'forum','fid'=>$forums[$fup1]['fid']))),
    			$fup1	=> array(strip_tags($forums[$fup]['name']),$this->url('system',array('s'=>'bbs','a'=>'forum','fid'=>$forums[$fup]['fid']))),
    			$fup	=> $fup_array
    		);
    	}

    	$navArray[] = ilink(setting('webname'), url('index'));
    	$navArray[] = ilink('社区', $this->url('system',array('s'=>'bbs')));
    	foreach ($guidename as $guide)
    	{
    	    $navArray[] = ilink($guide[0], $guide[1]);
    	}
    	
    	return implode('&gt;', $navArray);
    }

    /**
     * 是否允许显示一个管理面板
     * @param  $allows
     * @return bool
     */
    public function showLite($allows)
    {
        if ($allows['deleterp'] || $allows['ban'] || $allows['warning'] || $allows['ptop'] || $allows['dpreply'])
        {
            return true;
        }

        return false;
    }

    /**
     * 解析内容里的UBB代码
     * @param string $message
     * @param bool $isWap
     * @return string
     */
    public function ubbCode($message, $isWap = true)
    {
        // 直接调用include/Ubb.func.php里的iUbbCode()函数
        return str_replace("\n", "<br/>", iUbbCode($message, $isWap));
    }
    
    /**
     * 适用于社区的url产生方法，可以区分WAP、WEB，将来还要用在3G上
     * @param string $controller
     * @param array $params
     * @param string $sid
     * @return string
     */
    public function url($controller, $params = array(), $sid = null)
    {
        return url($controller, $params, $sid);
    }
    
    /**
     * 检查当前的请求类型
     * @return boolean
     */
    public function isWebRequest()
    {
        return isWebRequest();
    }
}