<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
class ThumbAction extends BbsAction
{    
    public function run()
    {
        $this->getController()->isLogin();
        $aid = intval(S::gp('aid','G'));
        $attachModel = Attachment::single();
        $attachDownModel = AttachDownload::single();
        try
        {
            $attachment = $attachModel->getOne($aid);
            Members::single()->hasMoney($this->uid(),$attachment['price'],$this->userName());
        }
        catch (AttachmentNotExistsException $exce)
        {
            throw new iSystemException($exce->getMessage());
        }
        catch (NotEnoughMoneyException $exce)
        {
            throw new iSystemException('当前附件下载需要'.$attachment['price'].setting('creditname'));
        }
        $thread = $this->getExistsThread($attachment['tid']);
        $allows = $this->getAllows($thread);
        !$allows['download'] && $this->NoPermission();
        
        $permissions = Members::single()->getPermissions($this->uid());
        if ($permissions['downloadattlimit'] && $permissions['downloadattlimit'] < $attachDownModel->today($this->uid()))
        {
            throw new iSystemException('您当前用户组每天只能下载'.$permissions['downloadattlimit'].'个附件');
        }
        
        if ($attachment['price'])
        {
            $check = $this->db()->getValue('SELECT COUNT(*) FROM '.AttachBuy::table().' WHERE uid='.$this->uid().' AND aid='.$aid);
            if (!$check && !$_GET['confirm'])
            {
                $message[] = '下载此文件需要消耗'.$attachment['price'].setting('creditname').'！你确定要购买下载吗？购买一次以后下载无需再购买！';
                $message[] = ilink('确定购买',url('system',array('s'=>'bbs','c'=>'attachment','a'=>'thumb','aid'=>$aid,'confirm'=>1))).'.'.ilink('以后再说',url('system',array('s'=>'bbs','a'=>'thread','tid'=>$attachment['tid'])));
                $this->showMessage($message);
            }
            
            if (!$check)
            {
                $iCredit = iCredits::single($this->uid(), $this->userName());
                $iCredit->consume($attachment['price']);
                $iCredit->setUid($attachment['uid']);
                $iCredit->setUserName(Members::single()->getNameByUid($this->uid()));
                $iCredit->addMoney($attachment['price']);
                $this->db()->insert(AttachBuy::table())->value(array('aid'=>$aid,'uid'=>$this->uid(),'ctype'=>1,'amount'=>$attachment['price'],'createdate'=>CTIME))->q();
            }
        }
        
        $width = S::gp('w','G');
        $height = S::gp('h','G');
        if (isset($width) && isset($height))
        {
            if (empty($width))
            {
                throw new iSystemException('请输入图片的宽度');
            }
            if (empty($height))
            {
                throw new iSystemException('请输入图片的高度');
            }
            
            $cut = S::gp('cut');
            !in_array($cut, array(0,1)) && $cut = 0;
            
            $sourFile = $attachModel->getFile($attachment['attachname']);
            $cacheFile = ROOT_PATH . 'cache/attach/' . substr(md5($aid),0,1) . '/' . $aid . '_' . $width . '_'.$height . '_' . $cut . '.' . fileext($sourFile);
            if (!is_file($cacheFile))
            {
                createFolder(dirname($cacheFile));
                $imgHandler = new iImageHandler();
                $imgHandler->setSrcImg($sourFile);
                $imgHandler->setCutType($cut);
                $imgHandler->setDstImg($cacheFile);
                $imgHandler->createImg($width, $height);
            }
            
            if (!is_file($cacheFile))
            {
                throw new iSystemException('不存在的附件');
            }
            
            $iDownload = new iDownload($cacheFile, $attachment['filename']);
            $iDownload->send();
        }
        else
        {
            $this->getController()->render('thumb',array('aid'=>$aid,'tid'=>$attachment['tid']));
        }
    }
}