<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
class BanAction extends BbsAction
{
    public function run()
    {
        $list = array('all' => '所有', 'post' => '发言', 'visit' => '访问');
        $fid = S::gp('fid', 'G', 2);
        $uid = S::gp('uid', 'G', 2);
        $type = S::gp('t');
        !key_exists($type, $list) && $type = 'all';
        $condition = $merge = array();

        if ('all' != $type)
        {
            $condition[] = '`type` = '.S::sqlEscape($type);
        }

        if ($fid)
        {
            $forum = $this->getController()->getForumCache($fid);
            empty($forum) && $this->showMessage('非法操作，请返回');
            $condition[] = 'fid = '.S::sqlEscape($fid);
            $merge = array('fid' => $fid);
        }
        if ($uid)
        {
            $condition[] = 'uid = '.S::sqlEscape($uid);
            $merge = array_merge($merge, array('uid' => $uid));
        }

        $condition = array() !== $condition ? ' WHERE ' . implode(' AND ', $condition) : '';
        $permissions = Members::single()->getPermissions($this->uid());
        $isBanPost = $permissions['isbanpost'];
        $isBanVisit = $permissions['isbanvisit'];
        
        $count = $this->db()->getValue('SELECT COUNT(*) FROM '.BanUser::table() . $condition);
        $pageObj = new iPage();
        $pageObj->setPageSize(10);
        $pageObj->setTotalRecord($count);
        
        $sql = 'SELECT * FROM '.BanUser::table().$condition.' ORDER BY id DESC LIMIT '.$pageObj->getOffset().','.$pageObj->getPageSize();

        $result = $this->db()->setQueryString($sql)->find();
        foreach ($result as $key => &$value)
        {
            switch ($value['type'])
            {
                case 'post':
                    $value['type'] = '发言';
                    break;
                default:
                    $value['type'] = '访问';
                    break;
            }

            if ('all' == $value['module'])
            {
                $value['fid'] = '全站';
            }
            else if ('bbs' == $value['module'] && !$value['fid'])
            {
                $value['fid'] = '社区';
            }
            else if ('bbs' == $value['module'] && $value['fid'])
            {
                $forumCache = Forums::single()->getCache($value['fid']);
                $value['fid'] = ilink($forumCache['name'], url('system', array('s'=>'bbs','a'=>'forum','fid'=>$value['fid'])));
            }
            else if ('forum' == $value['module'] && !$value['bid'])
            {
                $value['fid'] = '书会';
            }
            else if ('forum' == $value['module'] && $value['bid'])
            {
                $bookForum = getBookForum($value['bid']);
                $value['fid'] = ilink($bookForum['forumname'], url('system', array('s'=>'forum','id'=>$value['bid'])));
            }
            else
            {
                // 保险起见 ^_^
                $value['fid'] = '全站';
            }
        }
        
        foreach ($list as $k => $v)
        {
            if ($type == $k)
            {
                $nav[] = $v;
            }
            else
            {
                $nav[] = ilink($list[$k],url('system',array_merge(array('s'=>'bbs','a'=>'ban','t'=>$k), $merge)));
            }
        }
        $navString = implode('.',$nav);
        $floor = $pageObj->getFloor();

        $this->getController()->render('ban',array(
                'isBanPost' => $isBanPost,
                'isBanVisit' => $isBanVisit,
                'forum' => $forum,
                'pageObj' => $pageObj,
                'floor' => $floor,
                'result' => $result,
                'navString' => $navString,
            )
        );
    }
}