<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
class IndexAction extends BbsAction
{
    public function run()
    {
        $groupid = $this->uid() ? u('groupid') : 7;
        $forumList = $this->getController()->getForumListCache();
        $forums = $this->getController()->getForumsCache();
        $allowForums = array();
        foreach ($forumList as $key => $list)
        {
            if (empty($forums[$key]['allowvisit']) || false !== strpos($forums[$key]['allowvisit'], ",$groupid,"))
            {
                $allowForums[$key]['name'] = $list['name'];
                if (!empty($list['child']))
                {
                    foreach ($list['child'] as $id => $child)
                    {
                        if (empty($forums[$id]['allowvisit']) || false !== strpos($forums[$id]['allowvisit'], ",$groupid,"))
                        {
                            $allowForums[$key]['child'][$id] = $child;
                        }
                    }
                }
            }
        }
        
        foreach ($allowForums as $k => $v)
        {
            if (empty($v['child']))
            {
                unset($allowForums[$k]);
            }
        }
        
        if (!empty($allowForums))
        {
            $fids = array();
            foreach ($allowForums as $value)
            {
                if (!empty($value['child']))
                {
                    $childs = array_keys($value['child']);
                    $fids = array_merge($fids, $childs);
                    foreach ($childs as $v)
                    {
                        $adminArray = array();
                        $forumAdmins = explode(',', trim($forums[$v]['forumadmin'],','));
                        if (!empty($forumAdmins))
                        {
                            foreach ($forumAdmins as $a)
                            {
                                $adminArray[] = userName($a);
                            }
                        }
                        $forums[$v]['admin'] = implode(',', $adminArray);
                    }
                }
            }
            $sql = 'SELECT fid,threads,posts,todaythreads,todayposts,lastpost FROM '.Forums::table().' WHERE fid IN ('.implode(',', $fids).')';
            $result = $this->db()->setQueryString($sql)->find();
            $forumCounts = array();
            foreach ($result as $row)
            {
                if (!empty($row['lastpost']))
                {
                    $forums[$row['fid']]['lastpost'] = explode("\t", $row['lastpost']);
                } 
                $forumCounts[$row['fid']] = array('threads'=>$row['threads'],'posts'=>$row['posts'],'todaythreads'=>$row['todaythreads'],'todayposts'=>$row['todayposts']);
            }
        }
        if (!$this->getController()->isWebRequest())
        {
            $news = $this->db()->select(array('id','subject'))->from(Threads::table())->where('ischeck = 1 AND isdelete = 0')->desc('lastpost')->limit(15)->find();
        }
        else
        {
            $bbsinfo = $this->db()->select()->from(BbsInfo::table())->where('id=1')->find(true);
            $bbsinfo['newmember'] = explode("\t", $bbsinfo['newmember']);
            if ($bbsinfo['tposts'] > $bbsinfo['hposts'])
            {
                $this->db()->update(BbsInfo::table())->value(array('hposts'=>$bbsinfo['tposts']))->where('id=1')->q();
            }
        }

        $this->getController()->render('index', array(
                'allowForums' => $allowForums,
                'forumCounts' => $forumCounts,
                'forums' => $forums,
                'news' => $news,
                'iorange_id' => $this->uid(),
                'iorange' => $this->iorange(),
                'bbsinfo' => $bbsinfo,        
            )
        );
    }
}