<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
class ThreadAction extends BbsAction
{
    public function run()
    {
        $tid = S::gp('tid','G',2);
        $uid = S::gp('uid','G',2);
        $sort = S::gp('sort','G',2);
        $full = empty($_GET['f']) ? false : true;
        empty($tid) && $this->showMessage('非法操作，请返回');
        $pageSize = setting('pagesize');
        $pTable = Posts::table();
        $isWebRequest = $this->getController()->isWebRequest();
        $thread = $this->getExistsThread($tid);
        if ($thread['ishide'] && !isGM())
        {
            throw new iSystemException('您无权查看此贴');
        }
        $forum = $this->getController()->getForumCache($thread['fid']);

        $visitThreads = array();
        $cValue = explode(',', getCookieValue('tlist'));
        if (!empty($cValue))
        {
            foreach ($cValue as $cv)
            {
                if ($cv && is_numeric($cv))
                {
                    $visitThreads[] = $cv;
                }
            }
        }
        if (20 <= count($visitThreads))
        {
            array_pop($visitThreads);
        }
        if (!in_array($tid, $visitThreads))
        {
            array_unshift($visitThreads, $tid);
        }
        if (array() !== $visitThreads)
        {
            setCookieValue('tlist', implode(',', $visitThreads), CTIME + 24 * 3600 * 300);
        }

        if ($this->uid())
        {
            if (!$isWebRequest)
            {
                $pageSize = u('size');
                if (!isset($_SESSION['user']['bbs']['read'][$tid]))
                {
                    $_SESSION['user']['bbs']['read'][$tid] = 1;
                    $feed = '{{'.$this->uid().'}}阅读了[url='.staticUrl('system',array('s'=>'bbs','a'=>'thread','tid'=>$tid)).']《'.$this->getController()->filter($thread['subject']).'》[/url]';
                    iFeed::single()->create($feed, $this->uid());
                }
            }
        }
        
        $contentSize = mb_strlen($thread['content'], 'utf-8');
        if (!$isWebRequest && !$full && $contentSize > $pageSize)
        {
            $pageObj = new iPage();
            $pageObj->setPageSize($pageSize);
            $pageObj->setTotalRecord($contentSize);
            
            $thread['content'] = mb_substr($thread['content'], $pageObj->getOffset(), $pageSize, 'utf-8');
        }

        $thread = $this->analyzeRead($thread, 'thread');

        $this->db()->update(Threads::table())->incrField(array('hits'=>1))->where('id='.$tid)->q();
        $allows = $this->getAllows($thread);

        $replies = $thread['replies'];
        $order = 'toped DESC, id DESC';
        $limit = '5';
        $addCondition = '';
        if ($isWebRequest)
        {
            $currentPage = max(1, S::gp('page','G',2));
            $postPageSize = Posts::$pageSize;
            $order = 'id ASC';
            $limit = (($currentPage - 1) * $postPageSize).','.$postPageSize;
            if (2 == $sort)
            {
                $order = 'toped DESC, id DESC';
                $pages = $thread['replies'] - ($currentPage - 1) * $postPageSize;
            }
            else
            {
                $pages = ($currentPage - 1) * $postPageSize;
            }
            if ($uid)
            {
                $addCondition = ' AND uid='.S::sqlEscape($uid);
                $replies = $this->db()->getValue('SELECT COUNT(*) FROM '.$pTable.' WHERE tid='.S::sqlEscape($tid).' AND isdelete = 0 '.$addCondition);
            }
            $counter = ($currentPage - 1) * $postPageSize;
        }
        
        $posts = array();
        if ($thread['replies'] > 0)
        {
            $sql = 'SELECT id,tid,content,createdate,uid,username,source,floor,toped FROM '.$pTable.' WHERE tid='.S::sqlEscape($tid).' AND isdelete = 0 '.$addCondition.' ORDER BY '.$order.' LIMIT '.$limit;
            $query = $this->db()->query($sql);
            while ($post = $this->db()->getArr($query))
            {
                $posts[] = $this->analyzeRead($post, 'reply');
            }
        }
        
        $showThread = $currentPage > 1 ? false :true;
        
        $this->getController()->render('thread', array(
                'tid' => $tid,
                'forum' => $forum,
                'thread' => $thread,
                'posts' => $posts,
                'allows' => $allows,
                'pageObj' => $pageObj,
                'showThread' => $showThread,
                'pages' => $pages,
                'counter' => $counter,
                'replies' => $replies,
                'sort' => $sort,
                'postPageSize' => $postPageSize,
            )
        );
    }
}