<?php
import('bbs.controllers.thread.ThreadBaseAction');

class DefaultAction extends ThreadBaseAction
{
    public function run()
    {
        $fid = S::gp('fid','G');
        $special = S::gp('special','G',2);

        $forum = $this->getController()->getForumCache($fid);
        $permissions = Members::single()->getPermissions($this->uid());
        !$permissions['isbbspost'] && $this->NoPermission();
        
        if (!empty($_POST['content']))
        {
            try
            {
                $subject = S::gp('subject','P');
                $content = S::gp('content','P');
                if ($forum['forumset']['subjectlen'] > mb_strlen($subject, 'utf-8'))
                {
                    throw new iSystemException('标题长度不能少于'.$forum['forumset']['subjectlen'].'个字');
                }
                if ($forum['forumset']['threadlen'] > mb_strlen($content, 'utf-8'))
                {
                    throw new iSystemException('内容长度不能少于'.$forum['forumset']['threadlen'].'个字');
                }
                
                $days = S::gp('days','P');
                $type = S::gp('type','P');
                $threadModel = new Threads();
                $tid = $threadModel->create($subject, $content, $days, $type, $fid, $this->uid(), $this->userName());
            }
            catch (Exception $exce)
            {
                throw new iSystemException($exce->getMessage());
            }
            $this->updateCredits($this->uid(), $this->userName(), $forum['creditset'], 'post');

            iforward($this->getController()->url('system',array('s'=>'bbs','a'=>'thread','tid'=>$tid)));
        }
        
        $this->getController()->render('default', array(
                'fid' => $fid,
                'forum' => $forum,
            )
        );
    }
}