<?php
import('bbs.controllers.thread.ThreadBaseAction');

class EditAction extends ThreadBaseAction
{
    public function run()
    {
        $tid = S::gp('tid','G',2);
        $thread = $this->getExistsThread($tid);
        $allows = $this->getAllows($thread);
        $isAllowUpload = $this->isAllowUpload($this->uid(), $thread['fid']);
        $forum = $this->getController()->getForumCache($thread['fid']);
        
        if (!$allows['edit'])
        {
            throw new iSystemException('您当前所在的用户组不能编辑主题贴');
        }
        
        if (isset($_POST['content']))
        {
            if (!empty($_FILES) && !$isAllowUpload)
            {
                $this->NoPermission();
            }
            
            $uploadArray = array();
            if (!empty($_FILES))
            {
                try
                {
                    $uploadArray = $this->filterUpload();
                }
                catch (AttachmentIsEmpty $exce)
                {
                }
                catch (Exception $exce)
                {
                    $this->showMessage($exce->getMessage());
                }
            }
            
            $content = S::gp('content','P');
            $tArray = array(
                'rpdays' => S::gp('days','P'),
                'type' => S::gp('type','P'),
                'subject' => S::gp('subject','P'),
            );
            $lastupdate = serialize(array('uid'=>$this->uid(),'username'=>$this->userName(),'time'=>CTIME));
            $this->db()->update(Threads::table())->value($tArray)->where('id='.$tid)->q();
            $this->db()->update(ThreadsData::table())->value(array('content'=>$content,'lastupdate'=>$lastupdate))->where('tid='.$tid)->q();
            
            $updateArray = array();
            if ($this->getController()->isWebRequest())
            {
                $updateArray = array('isattreply'=>S::gp('attreply','P'));
            }
            $this->saveAttachment($tid, $uploadArray, $content, $updateArray);
            
            iforward(url('system',array('s'=>'bbs','a'=>'thread','tid'=>$tid)));
        }
        
        // TODO 特殊贴修改，根据实际情况确定是否要开发
        $special = $thread['special'];
        if ($special)
        {
            if (1 == $special)
            {
                
            }
            else if (2 == $special)
            {
                
            }
            else if (3 == $special)
            {
                
            }
        }
        
        $this->getController()->render('edit', array(
                'tid' => $tid,
                'thread' => $thread,
                'forum' => $forum,
                'isAllowUpload' => $isAllowUpload
            )
        );
    }
}