<?php
class AdvanceEditorWidget extends Widget
{
    public $inputName = 'content';
    
    public $inputId = 'postmessage';
    
    public $actionUrl = '';
    
    /**
     * 是否允许上传附件
     * @var unknown_type
     */
    public $isAllowUpload = false;
    
    /**
     * 一个帖子数组，修改时有效
     * @var array
     */
    public $thread = array();
    
    /**
     * 板块ID
     * @var int
     */
    public $fid;
    
    public function run()
    {
        $thread = $this->thread;
        $attachments = array();
        if ($thread['isupload'])
        {
            $attachments = $this->_getAttachments($thread['id']);
        }
        $this->render('AdvanceEditor', array(
                'fid' => $this->fid,
                'thread' => $thread,
                'attachments' => $attachments,
            )
        );
    }
    
    private function _getAttachments($id)
    {
        $attachments = $this->getOwner()->db()->select()->from(Attachment::table())->where('tid='.S::sqlEscape($id) . ' AND isdelete = 0')->find();
        return empty($attachments) ? array() : $attachments;
    }
}