<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
class BcartAction extends BaseAction
{
    public function run()
    {
        throw new iSystemException('子类必须覆盖此方法');
    }

    public function getCart()
    {
        $id = $_GET['id'] ? S::gp('id', 'G', 2) : S::gp('id', 'P', 2);
        if (!$id)
        {
            throw new iSystemException('Bcart:缺少必要的参数：id');
        }

        $cart = $this->db()->select()->from(Bcarts::table())->where(array('id'=>$id,'isdelete'=>0))->find(true);
        if (empty($cart))
        {
            throw new iSystemException('不存在的书单');
        }

        return $cart;
    }

    public function check()
    {
        $this->getController()->isLogin();

        $bcart = $this->getCart();
        if ($this->uid() != $bcart['uid'] && !isGM($this->uid()))
        {
            throw new iSystemException('这个书单不属于你');
        }

        return $bcart;
    }

    public function getSize($content)
    {
        $content = cleanSymbol(cleanEmpty($content));
        $content = str_replace(array('.', ',', '。', '，'), '', $content);

        return mb_strlen($content, 'utf-8');
    }
}
