<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
class ViewAction extends BcartAction
{
    public function run()
    {
        $bcart = $this->getCart();
        $bcartSubject = $this->db()->select()->from(BcartSubject::table())->where(array('bcid'=>$bcart['id'],'isdelete'=>0))->find();

        $coverCart = $coverArray = $bidArray = $infoArray = array();
        if (!empty($bcartSubject))
        {
            foreach ($bcartSubject as $key => &$value)
            {
                $book = getBookInfo($value['bid']);
                $bidArray[] = $value['bid'];
                $value['bookname'] = $book['bookname'];
                $value['author'] = $book['author'];

                $cover = bookCover($value['bid']);
                if (false !== $cover)
                {
                    $coverArray[$key] = array_merge($value, array('cover' => $cover));
                }
            }
        }
        
        if (array() !== $bidArray)
        {
            $in  = implode(',', $bidArray);
            $sql = 'SELECT bookid,bookinfo FROM '.Book::table().' WHERE bookid IN ('.$in.')';
            $result = $this->db()->setQueryString($sql)->find();
            if (!empty($result))
            {
                foreach ($result as $bValue)
                {
                    $infoArray[$bValue['bookid']] = iSubstr(preg_replace('/\s|\t|\n|\r/is', '', $bValue['bookinfo']), 0, 100, '...');
                }
            }
        }
        
        if (array() !== $coverArray)
        {
            $coverArray = shuffleAssoc($coverArray);
            foreach ($coverArray as $k => $v)
            {
                $coverCart = $v;
                break;
            }
            unset($bcartSubject[$k]);
        }
        $currentScore = Bcarts::getScore($bcart);

        $comments = $this->db()->select()->from(BcartComment::table())->where(array('bcid'=>$bcart['id']))->desc('id')->limit(5)->find();

        $allowManage = false;
        if ($this->uid() && $this->uid() == $bcart['uid'])
        {
            $allowManage = true;
        }

        if ($this->uid() && !isset($_SESSION['user']['bcart']['read'][$bcart['id']]))
        {
            $_SESSION['user']['bcart']['read'][$bcart['id']] = 1;
            $feed = '{{'.$this->uid().'}}阅读了书单[url='.staticUrl('system',array('s'=>'bcart','a'=>'view','id'=>$bcart['id'])).']《'.$this->getController()->filter($bcart['subject']).'》[/url]';
            iFeed::single()->create($feed, $this->uid());
        }

        $allowDeleteComment = false;
        if ($this->uid() && ($bcart['uid'] == $this->uid() || isGM()))
        {
            $allowDeleteComment = true;
        }
        
        $this->getController()->render('view', array(
                'uid' => $this->uid(),
                'bcart'=> $bcart,
                'bcartSubject'=> $bcartSubject,
                'coverCart' => $coverCart,
                'infoArray' => $infoArray,
                'currentScore' => $currentScore,
                'comments' => $comments,
                'allowManage' => $allowManage,
                'allowDeleteComment' => $allowDeleteComment,
            )
        );
    }
}
