<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
class AddBookAction extends BcartAction
{
    public function run()
    {
        $bcart = $this->check();
        $num = S::gp('num', 'G', 2);

        if (isset($_POST['save']))
        {
            $redirectUrl = urldecode(S::gp('redirect', 'G'));
            unset($_POST['save'], $_POST['id']);
            $subjectArray = $bookArray = array();
            foreach ($_POST as $key => $value)
            {
                if ($value)
                {
                    if (preg_match('/bid_(\d)/i', $key, $match))
                    {
                        $bookArray[$match[1]] = $value;
                    }

                    if (preg_match('/subject_(\d)/i', $key, $match))
                    {
                        $subjectArray[$match[1]] = $value;
                    }
                }
            }

            if (empty($bookArray))
            {
                throw new iSystemException('请输入要添加的小说ID,如果您不知道ID是多少,可以在每本小说的封面页查看到(bid:xxx 类似这样的)');
            }
            if (empty($subjectArray))
            {
                throw new iSystemException('每本书必须写上10个左右的短评,方便其他书友判断');
            }

            foreach ($bookArray as $key => $value)
            {
                $book = getBookInfo($value);
                $subject = $subjectArray[$key];
                
                if (empty($book))
                {
                    throw new iSystemException('ID为'.$value.'的小说不存在,请返回修改');
                }

                $subject = trim(preg_replace('/\s|\t|\n|\r/is', '', $subject));
                if (empty($subject))
                {
                    throw new iSystemException('ID为'.$value.'的短评不能为空,请返回修改');
                }
                if (10 > $this->getSize($subject))
                {
                    throw new iSystemException('ID为'.$value.'的短评不足10个字,请返回修改');
                }

                $check = $this->db()->getValue('SELECT COUNT(*) FROM '.BcartSubject::table().' WHERE isdelete = 0 AND uid='.S::sqlEscape($this->uid()).' AND bcid='.$bcart['id'].' AND bid='.S::sqlEscape($value));
                if ($check)
                {
                    throw new iSystemException('小说'.$book['bookname'].'已经存在此书单,请不要重复添加');
                }
                $this->db()->insert(BcartSubject::table())->value(array('bcid'=>$bcart['id'],'bid'=>$value,'description'=>$subject,'createdate'=>CDATETIME,'uid'=>$this->uid()))->q();
            }
            $bNum = $this->db()->getValue('SELECT COUNT(*) FROM '.BcartSubject::table().' WHERE uid='.S::sqlEscape($this->uid()).' AND isdelete = 0 AND bcid='.S::sqlEscape($bcart['id']));
            $update['bnum'] = $bNum;
            $update['display'] = 0;
            if ($bNum >= 3)
            {
                $update['display'] = 1;
            }
            $this->db()->update(Bcarts::table())->value($update)->where(array('id'=>$bcart['id']))->q();

            $message[] = '书单内容添加成功';
            $message[] = ilink('继续添加内容&gt;&gt;', url('system', array('s'=>'bcart', 'c'=>'member','a'=>'abook','id'=>$bcart['id'])));
            !empty($redirectUrl) && $message[] = ilink('返回继续阅读&gt;&gt;', $redirectUrl);
            $message[] = '返回'.ilink('我的书单',url('system', array('s'=>'bcart','c'=>'member'))).'.'.ilink('书单市场', url('system', array('s'=>'bcart'))).'.'.memberLink();
            $this->showMessage($message);
        }

        $viewName = $num ? 'addbook' : 'addbook_num';

        $this->getController()->render($viewName, array(
                'bcart' => $bcart,
                'num' => $num,
            )
        );
    }
}
