<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
class CommentAction extends BcartAction
{
    public function run()
    {
        $this->getController()->isLogin();
        $id = S::gp('id', 'G', 2);
        $bcart = $this->getCart();
        $redirectUrl = empty($_GET['redirect']) ? url('system', array('s'=>'bcart','a'=>'view','id'=>$id)) : urldecode(S::gp('redirect', 'G'));

        $check = getCookieValue('bc'.$id);
        if ($check)
        {
            throw new iSystemException('您说的太快了,休息一下!');
        }

        $content = S::gp('content', 'P');
        if (empty($content))
        {
            throw new iSystemException('评论内容不能为空');
        }

        if ($this->getSize($content) < 20)
        {
            throw new iSystemException('您不一定要评论,但如果写,评论内容最少不能低于20个字,谢谢您的支持!');
        }

        $content = iTool::saveAnalyze($content);
        $this->db()->insert(BcartComment::table())->value(array('bcid'=>$id,'content'=>$content,'createdate'=>CDATETIME,'ip'=>ONLINE_IP,'uid'=>$this->uid()))->q();
        $this->db()->update(Bcarts::table())->incrField(array('comment'=>1))->where(array('id'=>$bcart['id']))->q();
        setCookieValue('bc'.$id, 1, CTIME + 60);

        $feed = '{{'.$this->uid().'}}评论了书单[url='.staticUrl('system',array('s'=>'bcart','a'=>'view','id'=>$bcart['id'])).']《'.$this->getController()->filter($bcart['subject']).'》[/url]';
        iFeed::single()->create($feed, $this->uid());

        iforward($redirectUrl);
    }
}
