<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
class CreateAction extends BcartAction
{
    public function run()
    {
        $this->getController()->isLogin();

        $permissions = Members::single()->getPermissions($this->uid());
        $limit = $permissions['bcartlimit'];
        $count = $this->db()->getValue('SELECT COUNT(*) FROM '.Bcarts::table().' WHERE isdelete = 0 AND uid='.S::sqlEscape($this->uid()));
        if ($count >= $limit)
        {
            throw new iSystemException('您当前的等级只能创建'.$limit.'个书单,升级后将可以创建更多');
        }

        if (isset($_POST['subject']))
        {
            $subject = S::gp('subject', 'P');
            $description = S::gp('description', 'P');
            $tid = S::gp('tid', 'P', 2);

            if (empty($subject))
            {
                throw new iSystemException('书单名不能为空');
            }
            if (4 > $this->getSize($subject))
            {
                throw new iSystemException('书单名长度不能少于4个字');
            }

            if (empty($description))
            {
                throw new iSystemException('书单介绍不能为空');
            }
            if (10 > $this->getSize($description))
            {
                throw new iSystemException('书单介绍不能少于10个字');
            }
            $this->db()->insert(Bcarts::table())->value(array('uid'=>$this->uid(),'tid'=>$tid,'subject'=>$subject,'description'=>$description,'createdate'=>$description,'createdate'=>CDATETIME, 'date'=>CDATE))->q();
            $id = $this->db()->getInsertId();

            $feed = '{{'.$this->uid().'}}创建了书单[url='.staticUrl('system',array('s'=>'bcart','a'=>'view','id'=>$id)).']《'.$this->getController()->filter($subject).'》[/url]';
            iFeed::single()->create($feed, $this->uid());
            iforward(url('system', array('s'=>'bcart','c'=>'member','a'=>'abook','id'=>$id)));
        }

        $typeList = $this->db()->select()->from('type')->where(array('type'=>'bcart'))->find();
        $this->getController()->render('create', array(
                'limit' => $limit,
                'count' => $count,
                'typeList' => $typeList,
            )
        );
    }
}
