<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
class EditBookAction extends BcartAction
{
    public function run()
    {
        $bcart = $this->check();
        $bid = S::gp('bid', 'G', 2);
        $subject = $this->db()->select()->from(BcartSubject::table())->where(array('id'=>$bid,'isdelete'=>0))->find(true);
        if (empty($subject))
        {
            throw new iSystemException('不存在的书单内容');
        }

        if (isset($_POST['subject']))
        {
            $description = S::gp('subject', 'P');
            $bookId = S::gp('bookid', 'P', 2);

            $book = getBookInfo($bookId);
            if (empty($book))
            {
                throw new iSystemException('ID为'.$bookId.'的小说不存在,请返回修改');
            }

            $description = trim(preg_replace('/\s|\t|\n|\r/is', '', $description));
            if (empty($description))
            {
                throw new iSystemException('ID为'.$bookId.'的短评不能为空,请返回修改');
            }
            if (10 > $this->getSize($description))
            {
                throw new iSystemException('ID为'.$bookId.'的短评不足10个字,请返回修改');
            }

            if ($bookId != $subject['bid'])
            {
                $check = $this->db()->getValue('SELECT COUNT(*) FROM '.BcartSubject::table().' WHERE isdelete = 0 AND uid='.S::sqlEscape($this->uid()).' AND bcid='.$bcart['id'].' AND bid='.S::sqlEscape($bookId));
                if ($check)
                {
                    throw new iSystemException('小说'.$book['bookname'].'已经存在此书单,请不要重复添加');
                }
            }
            
            $this->db()->update(BcartSubject::table())->value(array('bid'=>$bookId,'description'=>$description,'updatedate'=>CDATETIME))->where(array('id'=>$bid))->q();
            $message[] = '书单内容修改成功';
            $message[] = '返回'.ilink('书单', url('system', array('s'=>'bcart','a'=>'view','id'=>$bcart['id']))).'.'.ilink('我的书单',url('system', array('s'=>'bcart','c'=>'member'))).'.'.ilink('书单市场', url('system', array('s'=>'bcart'))).'.'.memberLink();
            $this->showMessage($message);
        }
        $this->getController()->render('editbook', array(
                'bcart' => $bcart,
                'subject' => $subject,
            )
        );
    }
}
