<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
class ForumController extends BaseController
{
    public function url($controller, $params = array(), $merge = true, $sid = null)
    {
        $merge && $params = array_merge($params, $this->getMerge());
        
        return url($controller, $params, $sid);
    }
    
    public function getMerge($array = array())
    {
        $merge = array();
        
        $filter = trim(S::gp('filter','G'));
        !empty($filter) && !in_array($filter, array('digest','advance')) && $filter = '';
        
        switch ($filter)
        {
            case 'digest':
                $merge = array('filter' => 'digest');
                break;
            case 'advance':
                $merge = array('filter' => 'advance');
                break;
        }
        
        if (!empty($_GET['page']))
        {
            $merge = array_merge(array('page'=>S::gp('page','G',2)), $merge);
        }

        if (isset($_GET['start']) && preg_match('/^2[0-9]{3}-[0-9]{2}-[0-9]{2}$/i', trim($_GET['start'])))
        {
            $start = S::gp('start','G');
            if (isset($_GET['end']) && preg_match('/^2[0-9]{3}-[0-9]{2}-[0-9]{2}$/i', trim($_GET['end'])) && $_GET['end'] >= $start)
            {
                $end = S::gp('end','G');
            }
            else
            {
                $end = date('Y-m-d');
            }
            $merge = array_merge($merge, array('start'=>$start,'end'=>$end), $array);
        }
        
        return $merge;
    }
}