<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
class AddAction extends ForumAction
{
    public function run()
    {
        $this->getController()->isLogin();
        $permissions = Members::single()->getPermissions($this->uid());
        !$permissions['isadvancepost'] && $this->NoPermission();
        $isSellAdvance = $permissions['isselladvancepost'];
        $priceLimit = $permissions['advancepricelimit'];
        
        if (isset($_POST['subject']))
        {
            $price = S::gp('price','P',2);
            $subject = S::gp('subject','P');
            $content = S::gp('content','P');
            
            if ($price)
            {
                if (!$isSellAdvance)
                {
                    throw new iSystemException('您当前所在的用户组不能出售高级贴');
                }
                if ($price > $priceLimit)
                {
                    throw new iSystemException('您当前高级贴最高定价为'.$priceLimit);
                }
            }
            
            if (empty($subject) || mb_strlen($subject,'utf8') < 4)
            {
                throw new iSystemException('标题不能为空且不能少于4个字');
            }
            
            $bookpost = BookPost::single();
            if ($bookpost->isCanPost($this->id()))
            {
                $data = array(
                    'uid' => $this->uid(),
                    'message' => '标题:《'.$subject.'》 内容摘要:' . $content,
                    'isadvance' => 1,
                );
                $postId = $bookpost->create($this->id(), $data, true);
    
                $bookpost->updateUser($this->uid(), $this->userName());
    
                $reply = array(
                    'uid' => $this->uid(),
                    'username' => $this->userName(),
                    'postid' => $postId,
                    'subject' => $subject,
                    'content' => $content,
                    'price' => $price,
                    'isfirst' => 1,
                );
                BookPostReply::single()->create($this->id(), $reply);
                $this->db()->update(BookForum::table())
                     ->incrField(array('monthadvance'=>1,'advance'=>1))
                     ->where('bookid='.$this->id())
                     ->q();
    
                updateAdvancePost($this->id(), 3);
                
                $feed = '{{'.$this->uid().'}}发表了[url='.staticUrl('system',array('s'=>'forum','c'=>'advance','a'=>'read','id'=>$this->id(),'cid'=>$postId)).']《'.$subject.'》[/url]';
                iFeed::single()->create($feed, $this->id(), 'forum');

                $message[] = '发表成功';
                $message[] = '返回'.forumLink($this->id()).'.'.memberLink();
                $this->showMessage($message);
            }
        }
        
        $this->getController()->render('add', array(
                'bookid' => $this->id(),
                'isSellAdvance' => $isSellAdvance,
                'priceLimit' => $priceLimit,
            )
        );
    }
}