<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
class ComplaintsAction extends ForumAction
{
    public function run()
    {
        $bookPostReply = BookPostReply::single();
        $postId = S::gp('cid','G',2);
        $thread = $bookPostReply->getThread($postId);
        if (empty($thread))
        {
            throw new iSystemException('不存在的主题贴');
        }
        if ($bookPostReply->mustBuy($thread))
        {
            $bookPostReply->halt($thread);
        }
        if (in_array($this->uid(), explode(',', $thread['complaints'])))
        {
            throw new iSystemException('您已经投诉过了');
        }

        if (isset($_POST['content']))
        {
            $content = S::gp('content','P',1);
            if (empty($content))
            {
                throw new iSystemException('请输入投诉原因');
            }
            
            $data = array(
                'uid' => $this->uid(),
                'username' => $this->userName(),
                'postid' => $postId,
                'content' => $content,
                'subject' => $thread['subject'],
                'author' => $thread['username'],
                'authorid' => $thread['uid'],
            );
            BookPostComplaints::single()->create($this->id(), $data);
    
            $complaints = $thread['complaints'] . ',' . $this->uid();
            $this->db()->update($bookPostReply->table())->value(array('complaints'=>$complaints))->where(array('postid'=>$postId,'isfirst'=>1))->q();
            
            $message[] = '您的投诉已经提交，我们会尽快处理';
            $message[] = '返回'.ilink('帖子', url('system',array('s'=>'forum','c'=>'advacne','a'=>'read','id'=>$this->id(),'cid'=>$postId))).'.'.forumLink($this->id());
            $this->showMessage($message);
        }
        
        $this->getController()->render('complaints', array(
                'bookid' => $this->id(),
                'cid' => $postId,
            )
        );
    }
}