<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
class BookBmAction extends ForumAction
{
    public function run()
    {
        $bookInfo = $this->bookInfo();
        $forumInfo = $this->forumInfo();
        $month = date('Y-m');
        $denyUids = array(342582,172899,132557,3905,292106,244496,299544,345577,299541,299548,345566,223207,297282,297463,308037,297181,295575,377000,338756,379937,375000,380000,293935,132625,277924);
        
        if ($bookInfo['status'])
        {
            throw new iSystemException('已全本的小说不再进行申请');
        }
        if ($bookInfo['type'] == 2)
        {
            throw new iSystemException('原创小说不进行选举');
        }
        
        $m = date('Ym', strtotime('-1 month'));
        $check = $this->db()->getValue('SELECT COUNT(*) FROM '.BookForumMonth::table().' WHERE forumid='.S::sqlEscape($this->id()).' AND date = '.S::sqlEscape($m));
        if (!$check)
        {
            throw new iSystemException('提示:该书会在上月未能杀入前十,该月不设置书管,如果有意竞选,请为该书会的繁荣做出努力,感谢您的支持!');
        }
        if ($_GET['confirm'])
        {
            $this->getController()->isLogin();
            
            if (in_array($this->uid(), $denyUids))
            {
                throw new iSystemException('禁止申请');
            }
            
            if ($forumInfo['level'] < 4)
            {
                throw new iSystemException('4级以下书会不设书管');
            }
            
            $permissions = Members::single()->getPermissions($this->uid());
            if (!$permissions['isapplybm'])
            {
                $this->NoPermission();
            }
            
            if (IS_MANAGE && !IS_SUPER)
            {
                throw new iSystemException('您已经是当前书会书管，不需要申请，系统自动会将您列入选举名单');
            }
            
            $check = $this->db()->setQueryString("SELECT uid,username FROM ".ApplyBms::table()." WHERE FROM_UNIXTIME(createdate,'%Y-%m') = '$month' AND uid = '{$this->uid()}' AND bookid = {$this->id()} LIMIT 1")->find(ture);
            if (!empty($check))
            {
                throw new iSystemException('您已经提交过申请，请耐心等待投票开始');
            }
    
            $sql = "SELECT COUNT(*) AS c FROM ".ApplyBms::table()." WHERE FROM_UNIXTIME(createdate,'%Y-%m') = '$month' AND uid = '$this->uid()'";
            $check = $this->db()->getValue($sql);
            if (2 <= $check)
            {
                throw new iSystemException('一个人最多只能在2个书会申请');
            }
    
            try
            {
                Members::single()->hasMoney($this->uid(), 200, $this->userName());
            }
            catch (MemberNotExistsException $exce)
            {
                throw new iSystemException('你当前的'.setting('creditname').'不足200，不能申请');
            }
            
            iCredits::single($this->uid(), $this->userName())->consume(200);
            $this->db()->insert(ApplyBms::table())->value(array('uid'=>$this->uid(),'username'=>$this->userName(),'createdate'=>CTIME,'bookid'=>$this->id()))->q();
    
            $message[] = '恭喜您，申请提交成功！';
            $message[] = '返回'.forumLink($this->id()).'.'.memberLink().'.'.indexLink();
            $this->showMessage($message);
        }
        
        $this->getController()->render('bookbm', array(
                'bookid' => $this->id(),
                'bookInfo' => $bookInfo,
                'forumInfo' => $forumInfo,
            )
        );
    }
}