<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
class PostAction extends ForumAction
{
    public function run()
    {
        $this->isManager();
        $uid = S::gp('uid','G',2);
        
        if (isset($_POST['member']))
        {
            $module = 'forum';
            $range = S::gp('range','P', 2);
            $type = S::gp('type','P');
            $expiry = S::gp('expiry','P', 2);
            $m = S::gp('member','P');
            $reason = trim(S::gp('reason','P'));

            if (empty($reason))
            {
                throw new iSystemException('请输入禁言原因');
            }
 
            switch ($type)
            {
                case 'username':
                    $ban = 'm.username='.S::sqlEscape($m);
                    break;
                case 'uid':
                    $ban = 'm.uid='.S::sqlEscape(intval($m));
                    break;
            }
            $sql = "SELECT m.*, mf.*, u.gptype AS grouptype FROM ".Members::table()." AS m
                 	LEFT JOIN ".Memberfields::table()." mf ON mf.uid=m.uid
                 	LEFT JOIN ".UserGroups::table()." u ON u.groupid=m.groupid
                 	WHERE {$ban}";
            $member = $this->db()->setQueryString($sql)->find(true);
            if(!$member) 
            {
                throw new iSystemException('用户不存在');
            }
            if (isGM($member['uid']) || in_array($member['groupid'],array(4,5)) || ($range && BookBan::single()->isBan($member['uid'], $range)))
            {
                throw new iSystemException('您无权操作此等级用户');
            }
            
            if ($this->id())
            {
                $logs = $this->userName() . '[ID:' . $this->uid() . ']对' . $member['username'] . '[ID:'. $member['uid'] . ']执行"禁言"操作';
                $this->db()->insert(BookManageLog::table())
                     ->value(array('bookid'=>$range,'uid'=>$this->uid(),'username'=>$this->userName(),'message'=>$logs,'createdate'=>CDATETIME))
                     ->q();
            }

            $expiry = $expiry ? CTIME + ($expiry * 24 * 3600) : 0;
            if (0 == $range && IS_SUPER)
            {
                $module = 'all';
                groupOperate($member, $expiry, 4);
            }

            $data = array(
                'uid' => $member['uid'],
                'username' => $member['username'],
                'bookid' => $range,
                'remark' => $reason,
                'operate_uid' => $this->uid(),
                'operate_user' => $this->userName(),
                'createdate' => CDATETIME,
                'expiry' => $expiry,
            );
            BookBan::single()->create($data);
            
            if (isGM())
            {
                if ($_POST['cleanbbs'])
                {
                    cleanBbsPost($member['uid']);
                }
                if ($_POST['cleanforum'])
                {
                    //cleanForumPost($member['uid']);
                }
            }

            call_user_func_array(array(Members::single(),'ban'),array('member'=>$member,'reason'=>$reason,'uid'=>$this->uid(),'type'=>'post','module' => $module, 'id'=>$range,'expiry'=>$expiry - CTIME));

            $message[] = '禁言成功';
            $message[] = '返回'.($this->id() ? '' : forumLink($this->id()).'.').memberLink().'.'.indexLink();
            $this->showMessage($message);
        }
        
        $this->getController()->render('post', array(
        		'bookid' => $this->id(),
                'uid' => $uid,
            )
        );
    }
}