<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
class QuiteAction extends ForumAction
{
    public function run()
    {
        $this->getController()->isLogin();
        
        $forumMember = $this->db()->select()->from(BookMembers::table())->where(array('uid'=>$this->uid(),'bookid'=>$this->id(), 'deleted'=>0))->find(true);
        if (empty($forumMember))
        {
            throw new iSystemException('您不是本书会成员');
        }
        
        $iorange = $this->iorange();
        $credits = setting('forum_quite');
        $iCredit = iCredits::single($this->uid(), $this->userName());
        try
        {
            Members::single()->hasMoney($this->uid(), $credits, $this->userName());
        }
        catch (NotEnoughMoneyException $exce)
        {
            $credits = $iorange['user'][$iCredit->getMoneyField()];
        }

        $iCredit->consume($credits);
        $this->db()->update(BookMembers::table())->value(array('deleted'=>1,'updatedate'=>date('Y-m-d H:i:s')))->where(array('bookid'=>$this->id(),'uid'=>$this->uid()))->q();
        $this->db()->update(BookForum::table())->decrField(array('mcount'=>1))->where(array('bookid'=>$this->id()))->q();
        updateBookForum($this->id());

        $logs = '成员:' . $this->userName() . '[ID:'. $this->uid() . ']退出本书会';
        $this->db()->insert(BookManageLog::table())
             ->value(array('bookid'=>$this->id(),'uid'=>$this->uid(),'username'=>$this->userName(),'message'=>$logs,'createdate'=>date("Y-m-d H:i:s")))
             ->q();
        
        $message[] = '退会成功，你现在可以去加入别的书会了';
        $message[] = '返回' . forumLink($this->id()) . '.'.bookLink($this->id()) . '.' . memberLink();
        $this->showMessage($message);
    }
}