<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
class AddAction extends ForumAction
{
    public function run()
    {
        $cid = S::gp('cid','G',2);
        $this->isManager();
        
        if (!IS_SUPER)
        {
            $check = $this->db()->getValue('SELECT digest FROM '.BookManagers::table().' WHERE uid='.$this->uid().' AND status = 1 AND bookid='.$this->id());
            if (!$check)
            {
                throw new iSystemException('您今日的加精数已经用完');
            }
        }
        
        $row = BookPost::single()->getOne($cid, $this->id());
        if (empty($row))
        {
            throw new iSystemException('不存在的评论');
        }
        if ($this->uid() === $row['uid'])
        {
     	    throw new iSystemException('书管不能给自己的评论加精');
     	}
        if ($row['digest'] == 1)
        {
             throw new iSystemException('此评论已被加精，请不要重复加');
        }
        if ($row['isadvance'])
        {
            throw new iSystemException('高级贴不能加精');
        }
        if (mb_strlen($row['message'], 'utf8') < 50)
        {
            throw new iSystemException('精华评论长度不能小于50字');
        }
        if (preg_match('/\[ff=\d+/is', $row['message']))
        {
            throw new iSystemException('带引用的评论不能加精');
        }
        
        $bookInfo = $this->bookInfo();
        $this->db()->update(BookPost::table($this->id()))->value(array('digest'=>1))->where('bookpostsid='.$cid)->q();
        $subject = '[系统消息]您发表的书评被执行‘加精’操作';
        $content = '您在小说《'.$bookInfo['bookname'].'》发表的书评被书管“'.$this->userName().'”执行‘加精’操作';
        Members::sendMessage($subject, $content, $this->uid(), $this->userName(), $row['uid']);
        
        $this->db()->update(BookForum::table())
             ->incrField(array('digests'=>1,'income'=>2, 'monthdigests' => 1))
             ->where('bookid='.$this->id())
             ->q();
        if (!IS_SUPER)
        {
            $this->db()->update(BookManagers::table())
                       ->decrField(array('digest'=>1))
                       ->where(array('bookid'=>$this->id(),'uid'=>$this->uid()))
                       ->q();
        }
        
        $digestCredit = $bookInfo['type'] == 2 ? 50 : setting('comment_digest');
        iCredits::single($row['uid'], $row['username'])->addMoney($digestCredit);
        
        $forumInfo = $this->forumInfo();
        $feed = '[url='.staticUrl('system',array('s'=>'forum','id'=>$this->id())).']'.$forumInfo['forumname'].'[/url]书会有新精评自{{'.$row['uid'].'}}';
        iFeed::single()->create($feed, $row['uid'], 'forum');
        
        $logData = array(
            'uid' => $row['uid'],
            'ouid' => $this->uid(),
            'bookid' => $this->id(),
            'type' => 'AddDigest',
            'message' => '书友[uid='.$row['uid'].']的书评被[uid='.$this->uid().']设置为精华',
        );
        BookManageLog::single()->create($logData);

        $this->db()->insert(BookPostDigest::table())->value(array('postid'=>$row['bookpostsid'],'message'=>$row['message'],'uid'=>$row['uid'],'bookid'=>$this->id(),'createdate'=>$row['createdate'],'postdate'=>$row['date']))->q();
        updateDigestComment($this->id());

        iforward($this->getController()->url('system',array('s'=>'forum','id'=>$this->id())));
    }
}