<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
class CleanAction extends ForumAction
{
    public function run()
    {
        $this->isManager();
        $uid = S::gp('uid', 'G', 2);
        $type = S::gp('t', 'G', 2);
        if (!in_array($type, array(1,2,3,4)))
        {
            throw new iSystemException('非法清空操作，请返回');
        }
        if (in_array($type, array(3,4)) && !IS_SUPER)
        {
            throw new iSystemException('权限不够，不能清空');
        }

        try
        {
            $member = Members::single()->getOne($uid);
        }
        catch (MemberNotExistsException $exce)
        {
            throw new iSystemException($exce->getMessage());
        }

        if ($_POST['remark'])
        {
            $remark = S::gp('remark', 'P');
            if (empty($remark))
            {
                throw new iSystemException('请输入清空原因');
            }
            if (4 > mb_strlen($remark))
            {
                throw new iSystemException('清空原因不能少于4个字');
            }

            $monthCondition = $postCondition = ' WHERE uid=' . $uid . ' AND bookid = ' . $this->id();
            switch ($type)
            {
                case 4:
                    $msg = '本月';
                    $start = date('Y-m-').'01';
                    $postCondition .= ' AND `date` BETWEEN ' . S::sqlEscape($start).' AND '.S::sqlEscape(CDATE);
                    $monthCondition = $postCondition;
                    break;
                case 3:
                    $msg = '本周';
                    $monthCondition .= ' AND `week` = '.S::sqlEscape(date('W'));
                    $w = date('N') - 1;
                    $start = date('Y-m-d', strtotime('-'.$w.' days'));
                    $postCondition .= ' AND `date` BETWEEN ' . S::sqlEscape($start).' AND '.S::sqlEscape(CDATE);
                    break;
                case 2:
                    $msg = '3天';
                    $monthCondition .= ' AND `week` = '.S::sqlEscape(date('W'));
                    $start = date('Y-m-d', strtotime('-2 days'));
                    $postCondition .= ' AND `date` BETWEEN ' . S::sqlEscape($start).' AND '.S::sqlEscape(CDATE);
                    break;
                default:
                    $msg = '今天';
                    $monthCondition .= ' AND `date` = '.S::sqlEscape(CDATE);
                    $postCondition = $monthCondition;
                    break;
            }

            $postTable = BookPost::table($this->id());
            $count = $this->db()->getValue('SELECT COUNT(*) FROM '.BookPostMonth::table().$monthCondition);
            if (!$count)
            {
                throw new iSystemException('找不到该用户在本书会的书评，不能清空');
            }

            $isBackend = isGM($this->uid()) ? 1 : 0;
            $this->db()->insert(BookPostCleanLog::table())->value(array('uid'=>$uid,'operate_uid'=>$this->uid(),'date'=>CDATE,'createdate'=>CDATETIME,'count'=>$count,'bookid'=>$this->id(),'type'=>$type,'month'=>date('n'),'week'=>date('W'),'remark'=>$remark,'isbackend'=>$isBackend))->q();

            $sql = 'DELETE FROM '.BookPostMonth::table().$monthCondition;
            $this->db()->query($sql);

            $sql = 'DELETE FROM '.$postTable.$postCondition;
            $this->db()->query($sql);

            BookForum::single()->decrement(array('posts'=>$count,'monthposts'=>$count), $this->id());

            if ($count > 10)
            {
                $data = array(
                    'uid' => $member['uid'],
                    'username' => $member['username'],
                    'bookid' => $this->id(),
                    'remark' => '书会恶意刷评，系统自动禁言',
                    'operate_uid' => $this->uid(),
                    'operate_user' => $this->userName(),
                    'createdate' => CDATETIME,
                    'expiry' => CTIME + 24 * 3600 * 1,
                    'islock' => 1, // 书管不能解开
                );

                $check = $this->db()->getValue('SELECT COUNT(*) FROM '.BookPostCleanLog::table().' WHERE uid='.$uid.' AND `date` = '.S::sqlEscape(CDATE));
                if ($check >= 3)
                {
                    $data['bookid'] = 0;
                    $data['expiry'] = CTIME + 24 * 3600 * 3;
                }
                BookBan::single()->create($data);
            }

            $logData = array(
                'uid' => $member['uid'],
                'ouid' => $this->uid(),
                'bookid' => $this->id(),
                'type' => 'CleanPost',
                'message' => '书友[uid='.$member['uid'].']'.$msg.'的水评被[uid='.$this->uid().']清空',
            );
            BookManageLog::single()->create($logData);

            $message[] = '书评清理成功';
            $message[] = '返回'.forumLink($this->id()).'.'.memberLink().'.'.indexLink();
            $this->showMessage($message);
        }

        $this->getController()->render('clean', array('bookid'=>$this->id(),'uid'=>$uid,'type'=>$type));
    }
}
