<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
class FloorAction extends ForumAction
{
    public function run()
    {
        $this->isManager();
        
        $forumInfo = $this->forumInfo();
        $floor = unserialize($forumInfo['floor']);
        $floorSet = $this->getFloorSet($this->level());
        
        if (isset($_POST['c1']))
        {
            $c1 = S::gp('c1','P',2);
            $c2 = S::gp('c2','P',2);
            $c3 = S::gp('c3','P',2);
            $c4 = S::gp('c4','P',2);
            $c5 = S::gp('c5','P',2);
            $c6 = S::gp('c6','P',2);
            
            if ($c1 < $floorSet[1][1][0] || $c1 > $floorSet[1][1][1])
            {
                throw new iSystemException('本书会成员百楼分不能大'.$floorSet[1][1][1].'或者小于'.$floorSet[1][1][0]);
            }
            if ($c2 < $floorSet[2][1][0] || $c2 > $floorSet[2][1][1])
            {
                throw new iSystemException('非本书会成员百楼分不能大'.$floorSet[2][1][1].'或者小于'.$floorSet[2][1][0]);
            }
            if ($c3 < $floorSet[1][2][0] || $c3 > $floorSet[1][2][1])
            {
                throw new iSystemException('本书会成员千楼分不能大'.$floorSet[1][2][1].'或者小于'.$floorSet[1][2][0]);
            }
            if ($c4 < $floorSet[2][2][0] || $c4 > $floorSet[2][2][1])
            {
                throw new iSystemException('非本书会成员千楼分不能大'.$floorSet[2][2][1].'或者小于'.$floorSet[2][2][0]);
            }
            if ($c5 < $floorSet[1][3][0] || $c5 > $floorSet[1][3][1])
            {
                throw new iSystemException('本书会成员万楼分不能大'.$floorSet[1][3][1].'或者小于'.$floorSet[1][3][0]);
            }
            if ($c6 < $floorSet[2][3][0] || $c6 > $floorSet[2][3][1])
            {
                throw new iSystemException('非本书会成员万楼分不能大'.$floorSet[2][3][1].'或者小于'.$floorSet[2][3][0]);
            }
            
            $array = array(
                1 => array(1 => $c1, 2 => $c3, 3 => $c5),
        		2 => array(1 => $c2, 2 => $c4, 3 => $c6),
            );
            $this->db()->update(BookForum::table())->value(array('floor'=>serialize($array)))->where('bookid='.S::sqlEscape($this->id()))->q();
            BookForum::single()->refreshCache($this->id());
            
            $message[] = '设置成功';
            $message[] = '返回'.ilink('管理',url('system',array('s'=>'system','c'=>'manage','id'=>$this->id()))).'.'.forumLink($this->id());
            $this->showMessage($message);
        }
        
        //print_r($floor);die;
        $this->getController()->render('floor', array(
                'bookid' => $this->id(),
                'floorSet' => $floorSet,
                'floor' => $floor,
            )
        );
    }
}