<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
class FloorCreditAction extends ForumAction
{
    public function run()
    {
        $this->isManager();
        
        $fid = S::gp('fid','G',2);
        $do = S::gp('do','G');
        if (!in_array($do, array('credit','cancel')))
        {
            throw new iSystemException('非法操作，请返回');
        }
        
        $floor = $this->db()->select()->from(BookFloor::table())->where('id='.S::sqlEscape($fid))->find(true);
        if (empty($floor))
        {
            throw new iSystemException('不存在的楼层');
        }
        if ($floor['status'])
        {
            throw new iSystemException('此楼层已不可再操作');
        }
        
        $updateArray = array('operate_uid'=>$this->uid(),'updatedate'=>CDATETIME);
        if ('credit' == $do)
        {
            $forumInfo = $this->forumInfo();
            iCredits::single($floor['uid'], userName($floor['uid']))->addMoney($floor['credits']);
            $subject = '[系统消息]获得'.BookFloor::$typeMap[$floor['type']].'奖励';
            $content = '恭喜您获得《'.$forumInfo['forumname'].'》书会'.BookFloor::$typeMap[$floor['type']].$floor['credits'].setting('creditname').'奖励';
            Members::sendMessage($subject, $content, 1, 'admin', $floor['uid']);
            $updateArray = array_merge($updateArray, array('status' => 1));
            
            $this->db()->insert(BookCreditsLog::table())->value(array('date'=>CDATE,'createdate'=>CDATETIME,'bid'=>$this->id(),'uid'=>$floor['uid'],'username'=>userName($floor['uid']),'operater_id'=>$this->uid(),'operater'=>$this->userName(),'credit'=>$floor['credits']))->q();
        }
        else if ('cancel' == $do)
        {
            $updateArray = array_merge($updateArray, array('status' => 2));
            BookForum::single()->addSelf(array('income'=>$floor['credits']), $floor['bookid']);
        }
        $this->db()->update(BookFloor::table())->value($updateArray)->where('id='.S::sqlEscape($fid))->q();
        iforward(url('system', array('s'=>'forum','a'=>'floor','id'=>$this->id())));
    }
}