<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
class MessageAction extends ForumAction
{
    public function run()
    {
        $this->isManager();
        
        if (isset($_POST['content']))
        {
            $subject = S::gp('subject','P');
            $content = S::gp('content','P');
            if (empty($subject))
            {
                throw new iSystemException('请输入标题');
            }
            if (mb_strlen($subject, 'utf-8') > 30 || mb_strlen($subject, 'utf-8') < 1)
            {
                throw new iSystemException('标题长度不能大于30或者小于1个字');
            }
            if (empty($content))
            {
                throw new iSystemException('请输入内容');
            }
            if (mb_strlen($content, 'utf-8') > 200 || mb_strlen($content, 'utf-8') < 5)
            {
                throw new iSystemException('内容长度不能大于300或者小于5个字');
            }
            $members = $this->db()->select()->from(BookMembers::table())->where(array('bookid'=>$this->id(),'deleted'=>0))->find();
            if (empty($members))
            {
                throw new iSystemException('本书会还没有会员，不能群发短信');
            }
            
            $subject = '[书会群发]'.$subject;
            set_time_limit(300);
            $did = MessageData::single()->create($subject, $content);
            foreach ($members as $member)
            {
                Message::single()->send($did, $this->uid(), $this->userName(), $member['uid']);
            }
            
            $message[] = '短信群发成功';
            $message[] = '返回'.ilink('管理',url('system',array('s'=>'forum','c'=>'manage','id'=>$this->id()))).'.'.forumLink($this->id());
            $this->showMessage($message);
        }
        $this->getController()->render('message', array(
                'bookid' => $this->id(),
                'forumInfo' => $this->forumInfo(),
            )
        );
    }
}