<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
class DeleteAction extends ForumAction
{
    public function run()
    {
        if (!IS_MANAGE && !IS_DEPUTY)
        {
            $this->NoPermission();
        }
        
        $cid = S::gp('cid','G',2);
        $row = $this->db()->select(array('uid','isadvance', 'digest'))
                    ->from(BookPost::table($this->id()))
                    ->where('bookpostsid='.$cid)
                    ->find(true);

        if (empty($row))
        {
            throw new iSystemException('评论不存在');
        }

        if ($row['digest'])
        {
            throw new iSystemException('精评必须取消后才能删除');
        }
        
        if ($_GET['confirm'] && isset($_POST['remarks']))
        {
            $remarks = $this->getController()->filter(S::gp('remarks','P'));
            if (empty($remarks))
            {
                throw new iSystemException('请输入删除理由');
            }
            $bookInfo = $this->bookInfo();
            $subject = '[系统消息]您发表的书评被执行‘删除’操作';
            $content = '您在小说《'.$bookInfo['bookname'].'》发表的书评被书管“'.$this->userName()."”执行‘删除’操作。\n操作理由:".$remarks."\n如果您对本管理操作有异议，请与我取得联系。";
            Members::sendMessage($subject, $content, $this->uid(), $this->userName(), $row['uid']);
            
            BookPost::single()->delete($cid, $this->id(), $this->uid(), $this->userName(), $remarks);

            $commentDelCredit = setting('comment_del');
            if ($row['digest'])
            {
                $commentDelCredit = 2 == $bookInfo['type'] ? 100 : 4;
            }
            $userName = userName($row['uid']);
            $creditObj = iCredits::single($row['uid'], $userName);
            $this->db()->query('UPDATE '.Members::table()." SET `{$creditObj->getMoneyField()}` = `{$creditObj->getMoneyField()}` - ".$commentDelCredit." WHERE `uid` = '{$row['uid']}'");

            $tag = IS_SUPER ? '超管' : (IS_DEPUTY ? '副管' : '书管');
            $logData = array(
                'uid' => $row['uid'],
                'ouid' => $this->uid(),
                'bookid' => $this->id(),
                'type' => 'DeletePost',
                'message' => '书友[uid='.$row['uid'].']的书评被'.$tag.'[uid='.$this->uid().']删除',
                'remark' => $remarks,
            );
            BookManageLog::single()->create($logData);

            updateDigestComment($this->id());
            $row['isadvance'] && updateAdvancePost($this->id(), 3);
            iforward($this->getController()->url('system',array('s'=>'forum','id'=>$this->id())));
        }
        
        $this->getController()->render('delete', array(
                'bookid' => $this->id(),
                'cid' => $cid,
                'merge' => $this->getMerge(),
            )
        );
    }
}