<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
class ToAction extends ForumAction
{
    public function run()
    {
        $cid = S::gp('cid','G',2);
        $post = BookPost::single()->getOne($cid, $this->id());
        $type = S::gp('type', 'P');
        $type = '对这楼说' == $type ? 1 : 0; // - - 猥琐的代码
        
        if (empty($post))
        {
            throw new iSystemException('不存在的评论');
        }
        try
        {
            $member = Members::single()->getOne($post['uid']);
        }
        catch (MemberNotExistsException $exce)
        {
            throw new iSystemException($exce->getMessage());
        }

        if ($post['isadvance'])
        {
            throw new iSystemException('高级贴无法使用此功能');
        }
        
        if (isset($_POST['content']))
        {
            if ($type && $post['uid'] == $this->uid())
            {
                throw new iSystemException('禁止对自己说');
            }
            
            $bookpost = BookPost::single();
            if ($bookpost->isCanPost($this->id()))
            {
                $data = array(
                    'uid' => $this->uid(),
                    'username' => $this->userName(),
                    'message' => S::gp('content', 'P'),
                    'action' => S::gp('a', 'P', 2),
                    'touid' => $member['uid'],
                    'totype' => $type,
                    'post' => $post,
                );
                $bookpost->create($this->id(), $data);
            }
            $bookpost->updateUser($this->uid(), $this->userName());
            iforward($this->getController()->url('system',array('s'=>'forum','id'=>$this->id())));
        }
        
        if ($post['isadvance'] && mb_strlen($post['message'],'utf8') > 50)
        {
            $post['message'] = mb_substr($post['message'], 0, 50, 'utf-8');
            $post['message'] = $this->getController()->filter($post['message']);
            $post['message'] .= ilink('...详细', $this->getController()->url('system',array('s'=>'forum','c'=>'advance','a'=>'read','id'=>$this->id(),'cid'=>$post['bookpostsid'])));
        }
        
        $this->getController()->render('to', array(
                'bookid' => $this->id(),
                'cid' => $cid,
                'post' => $post,
            )
        );
    }
}