<?php
/*
* 项目: iOrange(橘子)
* 作者: 离家出走(yzxh24)
* Email: yzxh24@gmail.com
* 主页: www.iorange.cc
*/
/* vim: set ts=4 sw=4: */
class TodayAction extends BaseAction
{
    public function run()
    {
        if (!IS_SUPER && !isGM($this->uid()))
        {
            throw new iSystemException('权限不足');
        }
        
        $uid = S::gp('uid', 'G', 2);
        $bookId = S::gp('id', 'G', 2);
        
        try
        {
            $member = Members::single()->getOne($uid);
        }
        catch (Exception $exce)
        {
            throw new iSystemException($exce->getMessage());
        }

        $count = $this->db()->getValue('SELECT COUNT(*) FROM '.BookPostMonth::table().' WHERE uid = '.$uid.' AND date='.S::sqlEscape(CDATE));
        $pageObj = new iPage();
        $pageObj->setTotalRecord($count);
        $pageObj->setPageSize(20);

        $sql = 'SELECT bookpostsid,uid,bookid,message,createdate,isadvance,stable FROM '.BookPostMonth::table().' WHERE uid='.$uid.' AND date='.S::sqlEscape(CDATE).' ORDER BY bookpostsid DESC '.S::sqlLimit($pageObj->getOffset(), $pageObj->getPageSize());
        $posts = $this->db()->setQueryString($sql)->find();
        if (!empty($posts))
        {
            foreach ($posts as &$post)
            {
                $forum = getBookForum($post['bookid']);
                $post['name'] = $forum['forumname'];
            }
        }
        $floor = $pageObj->getFloor();

        $this->getController()->render('today', array('posts'=>$posts,'pageObj'=>$pageObj,'floor'=>$floor,'uid'=>$uid,'bookid'=>$bookId));
    }
}